/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.bytebuddy.interceptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.shenyu.agent.api.entity.MethodResult;
import org.apache.shenyu.agent.api.handler.StaticMethodHandler;
import org.apache.shenyu.agent.core.bytebuddy.interceptor.ConstructorInterceptor;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ConstructorInterceptor.class);
    private final List<StaticMethodHandler> handlerList;

    public StaticMethodInterceptor(List<StaticMethodHandler> handlerList) {
        this.handlerList = handlerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RuntimeType
    public Object intercept(@Origin Class<?> klass, @Origin Method method, @AllArguments Object[] args, @SuperCall Callable<?> callable) throws Exception {
        Object result = null;
        for (StaticMethodHandler handler : this.handlerList) {
            MethodResult methodResult = new MethodResult();
            try {
                handler.before(klass, method, args, new MethodResult());
            }
            catch (Throwable ex) {
                LOG.error("Failed to execute the before method of method {} in class {}", new Object[]{method.getName(), klass, ex});
            }
            result = callable.call();
            try {
                handler.after(klass, method, args, methodResult);
            }
            catch (Throwable ex) {
                LOG.error("Failed to execute the after method of method {} in class {}", new Object[]{method.getName(), klass, ex});
            }
            continue;
            catch (Throwable ex) {
                try {
                    try {
                        handler.onThrowing(klass, method, args, ex);
                    }
                    catch (Throwable ignored) {
                        LOG.error("Failed to execute the error handler of method {} in class {}", new Object[]{method.getName(), klass, ex});
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        handler.after(klass, method, args, methodResult);
                    }
                    catch (Throwable ex2) {
                        LOG.error("Failed to execute the after method of method {} in class {}", new Object[]{method.getName(), klass, ex2});
                    }
                    throw throwable;
                }
                try {
                    handler.after(klass, method, args, methodResult);
                }
                catch (Throwable ex3) {
                    LOG.error("Failed to execute the after method of method {} in class {}", new Object[]{method.getName(), klass, ex3});
                }
            }
        }
        return result;
    }
}

