/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.bytebuddy.interceptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.shenyu.agent.api.entity.MethodResult;
import org.apache.shenyu.agent.api.entity.TargetObject;
import org.apache.shenyu.agent.api.handler.InstanceMethodHandler;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceMethodInterceptor.class);
    private final List<InstanceMethodHandler> handlerList;

    public InstanceMethodInterceptor(List<InstanceMethodHandler> handlerList) {
        this.handlerList = handlerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RuntimeType
    public Object intercept(@This Object target, @Origin Method method, @AllArguments Object[] args, @SuperCall Callable<?> callable) throws Exception {
        Object result = null;
        TargetObject instance = (TargetObject)target;
        for (InstanceMethodHandler handler : this.handlerList) {
            MethodResult methodResult = new MethodResult();
            try {
                handler.before(instance, method, args, methodResult);
            }
            catch (Throwable ex) {
                LOG.error("Failed to execute the before method of method {} in class {}", new Object[]{method.getName(), target.getClass(), ex});
            }
            result = callable.call();
            try {
                result = handler.after(instance, method, args, methodResult, result);
            }
            catch (Throwable ex) {
                LOG.error("Failed to execute the after method of method {} in class {}", new Object[]{method.getName(), target.getClass(), ex});
            }
            continue;
            catch (Throwable ex) {
                try {
                    try {
                        handler.onThrowing(instance, method, args, ex);
                    }
                    catch (Throwable ignored) {
                        LOG.error("Failed to execute the error handler of method {} in class {}", new Object[]{method.getName(), target.getClass(), ex});
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        result = handler.after(instance, method, args, methodResult, result);
                    }
                    catch (Throwable ex2) {
                        LOG.error("Failed to execute the after method of method {} in class {}", new Object[]{method.getName(), target.getClass(), ex2});
                    }
                    throw throwable;
                }
                try {
                    result = handler.after(instance, method, args, methodResult, result);
                }
                catch (Throwable ex3) {
                    LOG.error("Failed to execute the after method of method {} in class {}", new Object[]{method.getName(), target.getClass(), ex3});
                }
            }
        }
        return result;
    }
}

