/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.bytebuddy.interceptor;

import java.util.List;
import org.apache.shenyu.agent.api.entity.TargetObject;
import org.apache.shenyu.agent.api.handler.ConstructorHandler;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ConstructorInterceptor.class);
    private final List<ConstructorHandler> handlerList;

    public ConstructorInterceptor(List<ConstructorHandler> handlerList) {
        this.handlerList = handlerList;
    }

    @RuntimeType
    public void intercept(@This TargetObject target, @AllArguments Object[] args) {
        for (ConstructorHandler handler : this.handlerList) {
            try {
                handler.onConstructor(target, args);
            }
            catch (Throwable throwable) {
                LOG.error("Constructor advice execution error. class: {}", (Object)target.getClass().getTypeName(), (Object)throwable);
            }
        }
    }
}

