/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import com.alibaba.fastjson.JSON;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.RpcContext;

public final class AccessLogData {
    private static final String MESSAGE_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat MESSAGE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String VERSION = "version";
    private static final String GROUP = "group";
    private static final String SERVICE = "service";
    private static final String METHOD_NAME = "method-name";
    private static final String INVOCATION_TIME = "invocation-time";
    private static final String TYPES = "types";
    private static final String ARGUMENTS = "arguments";
    private static final String REMOTE_HOST = "remote-host";
    private static final String REMOTE_PORT = "remote-port";
    private static final String LOCAL_HOST = "localhost";
    private static final String LOCAL_PORT = "local-port";
    private Map<String, Object> data;

    private AccessLogData() {
        RpcContext context = RpcContext.getContext();
        this.data = new HashMap<String, Object>();
        this.setLocalHost(context.getLocalHost());
        this.setLocalPort(context.getLocalPort());
        this.setRemoteHost(context.getRemoteHost());
        this.setRemotePort(context.getRemotePort());
    }

    public static AccessLogData newLogData() {
        return new AccessLogData();
    }

    public void setVersion(String version) {
        this.set(VERSION, version);
    }

    public void setServiceName(String serviceName) {
        this.set(SERVICE, serviceName);
    }

    public void setGroup(String group) {
        this.set(GROUP, group);
    }

    public void setInvocationTime(Date invocationTime) {
        this.set(INVOCATION_TIME, invocationTime);
    }

    private void setRemoteHost(String remoteHost) {
        this.set(REMOTE_HOST, remoteHost);
    }

    private void setRemotePort(Integer remotePort) {
        this.set(REMOTE_PORT, remotePort);
    }

    private void setLocalHost(String localHost) {
        this.set(LOCAL_HOST, localHost);
    }

    private void setLocalPort(Integer localPort) {
        this.set(LOCAL_PORT, localPort);
    }

    public void setMethodName(String methodName) {
        this.set(METHOD_NAME, methodName);
    }

    public void setTypes(Class[] types) {
        this.set(TYPES, types != null ? Arrays.copyOf(types, types.length) : null);
    }

    public void setArguments(Object[] arguments) {
        this.set(ARGUMENTS, arguments != null ? Arrays.copyOf(arguments, arguments.length) : null);
    }

    public String getServiceName() {
        return this.get(SERVICE).toString();
    }

    public String getLogMessage() {
        Object[] args;
        String version;
        String group;
        StringBuilder sn = new StringBuilder();
        sn.append("[").append(MESSAGE_DATE_FORMATTER.format(this.getInvocationTime())).append("] ").append(this.get(REMOTE_HOST)).append(":").append(this.get(REMOTE_PORT)).append(" -> ").append(this.get(LOCAL_HOST)).append(":").append(this.get(LOCAL_PORT)).append(" - ");
        String string = group = this.get(GROUP) != null ? this.get(GROUP).toString() : "";
        if (StringUtils.isNotEmpty(group)) {
            sn.append(group).append("/");
        }
        sn.append(this.get(SERVICE));
        String string2 = version = this.get(VERSION) != null ? this.get(VERSION).toString() : "";
        if (StringUtils.isNotEmpty(version)) {
            sn.append(":").append(version);
        }
        sn.append(" ");
        sn.append(this.get(METHOD_NAME));
        sn.append("(");
        Class[] types = this.get(TYPES) != null ? (Class[])this.get(TYPES) : new Class[]{};
        boolean first = true;
        for (Class type : types) {
            if (first) {
                first = false;
            } else {
                sn.append(",");
            }
            sn.append(type.getName());
        }
        sn.append(") ");
        Object[] objectArray = args = this.get(ARGUMENTS) != null ? (Object[])this.get(ARGUMENTS) : null;
        if (args != null && args.length > 0) {
            sn.append(JSON.toJSONString((Object)args));
        }
        return sn.toString();
    }

    private Date getInvocationTime() {
        return (Date)this.get(INVOCATION_TIME);
    }

    private Object get(String key) {
        return this.data.get(key);
    }

    private void set(String key, Object value) {
        this.data.put(key, value);
    }
}

