/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.grpc;

import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ReferenceCountManagedChannel
extends ManagedChannel {
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private ManagedChannel grpcChannel;

    public ReferenceCountManagedChannel(ManagedChannel delegated) {
        this.grpcChannel = delegated;
    }

    public void incrementAndGetCount() {
        this.referenceCount.incrementAndGet();
    }

    public ManagedChannel shutdown() {
        if (this.referenceCount.decrementAndGet() <= 0) {
            return this.grpcChannel.shutdown();
        }
        return this.grpcChannel;
    }

    public boolean isShutdown() {
        return this.grpcChannel.isShutdown();
    }

    public boolean isTerminated() {
        return this.grpcChannel.isTerminated();
    }

    public ManagedChannel shutdownNow() {
        return this.shutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.grpcChannel.awaitTermination(timeout, unit);
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.grpcChannel.newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.grpcChannel.authority();
    }
}

