/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Decodeable;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.dubbo.CallbackServiceCodec;
import org.apache.dubbo.rpc.protocol.dubbo.DubboCodec;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DecodeableRpcInvocation
extends RpcInvocation
implements Codec,
Decodeable {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcInvocation.class);
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Request request;
    private volatile boolean hasDecoded;

    public DecodeableRpcInvocation(Channel channel, Request request, InputStream is, byte id) {
        Assert.notNull((Object)channel, "channel == null");
        Assert.notNull((Object)request, "request == null");
        Assert.notNull((Object)is, "inputStream == null");
        this.channel = channel;
        this.request = request;
        this.inputStream = is;
        this.serializationType = id;
    }

    @Override
    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc invocation failed: " + e.getMessage(), e);
                }
                this.request.setBroken(true);
                this.request.setData(e);
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    @Override
    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object decode(Channel channel, InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerialization(channel.getUrl(), this.serializationType).deserialize(channel.getUrl(), input);
        String dubboVersion = in.readUTF();
        this.request.setVersion(dubboVersion);
        this.setAttachment("dubbo", dubboVersion);
        String path = in.readUTF();
        this.setAttachment("path", path);
        this.setAttachment("version", in.readUTF());
        this.setMethodName(in.readUTF());
        String desc = in.readUTF();
        this.setParameterTypesDesc(desc);
        try {
            Object[] args = DubboCodec.EMPTY_OBJECT_ARRAY;
            Class<?>[] pts = DubboCodec.EMPTY_CLASS_ARRAY;
            if (desc.length() > 0) {
                MethodDescriptor methodDescriptor;
                ServiceRepository repository = ApplicationModel.getServiceRepository();
                ServiceDescriptor serviceDescriptor = repository.lookupService(path);
                if (serviceDescriptor != null && (methodDescriptor = serviceDescriptor.getMethod(this.getMethodName(), desc)) != null) {
                    pts = methodDescriptor.getParameterClasses();
                    this.setReturnTypes(methodDescriptor.getReturnTypes());
                }
                if (pts == DubboCodec.EMPTY_CLASS_ARRAY) {
                    if (!RpcUtils.isGenericCall(desc, this.getMethodName()) && !RpcUtils.isEcho(desc, this.getMethodName())) {
                        throw new IllegalArgumentException("Service not found:" + path + ", " + this.getMethodName());
                    }
                    pts = ReflectUtils.desc2classArray(desc);
                }
                args = new Object[pts.length];
                for (int i = 0; i < args.length; ++i) {
                    try {
                        args[i] = in.readObject(pts[i]);
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn("Decode argument failed: " + e.getMessage(), e);
                    }
                }
            }
            this.setParameterTypes(pts);
            Map<String, Object> map = in.readAttachments();
            if (map != null && map.size() > 0) {
                Map<String, Object> attachment = this.getObjectAttachments();
                if (attachment == null) {
                    attachment = new HashMap<String, Object>();
                }
                attachment.putAll(map);
                this.setObjectAttachments(attachment);
            }
            for (int i = 0; i < args.length; ++i) {
                args[i] = CallbackServiceCodec.decodeInvocationArgument(channel, this, pts, i, args[i]);
            }
            this.setArguments(args);
            String targetServiceName = URL.buildKey(this.getAttachment("path"), this.getAttachment("group"), this.getAttachment("version"));
            this.setTargetServiceUniqueName(targetServiceName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(StringUtils.toString("Read invocation data failed.", e));
        }
        finally {
            if (in instanceof Cleanable) {
                ((Cleanable)((Object)in)).cleanup();
            }
        }
        return this;
    }
}

