/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(order=100)
public class ProtocolFilterWrapper
implements Protocol {
    private final Protocol protocol;

    public ProtocolFilterWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    private static <T> Invoker<T> buildInvokerChain(final Invoker<T> invoker, String key, String group) {
        Invoker last = invoker;
        List<Filter> filters = ExtensionLoader.getExtensionLoader(Filter.class).getActivateExtension(invoker.getUrl(), key, group);
        if (!filters.isEmpty()) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                final Filter filter = filters.get(i);
                final Invoker next = last;
                last = new Invoker<T>(){

                    @Override
                    public Class<T> getInterface() {
                        return invoker.getInterface();
                    }

                    @Override
                    public URL getUrl() {
                        return invoker.getUrl();
                    }

                    @Override
                    public boolean isAvailable() {
                        return invoker.isAvailable();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public Result invoke(Invocation invocation) throws RpcException {
                        try {
                            Result asyncResult = filter.invoke(next, invocation);
                            return asyncResult.whenCompleteWithContext((r, t) -> {
                                if (filter instanceof ListenableFilter) {
                                    ListenableFilter listenableFilter = (ListenableFilter)filter;
                                    Filter.Listener listener = listenableFilter.listener(invocation);
                                    try {
                                        if (listener == null) return;
                                        if (t == null) {
                                            listener.onResponse((Result)r, invoker, invocation);
                                            return;
                                        }
                                        listener.onError((Throwable)t, invoker, invocation);
                                        return;
                                    }
                                    finally {
                                        listenableFilter.removeListener(invocation);
                                    }
                                } else {
                                    if (!(filter instanceof Filter.Listener)) return;
                                    Filter.Listener listener = (Filter.Listener)((Object)filter);
                                    if (t == null) {
                                        listener.onResponse((Result)r, invoker, invocation);
                                        return;
                                    } else {
                                        listener.onError((Throwable)t, invoker, invocation);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            if (filter instanceof ListenableFilter) {
                                ListenableFilter listenableFilter = (ListenableFilter)filter;
                                try {
                                    Filter.Listener listener = listenableFilter.listener(invocation);
                                    if (listener == null) throw e;
                                    listener.onError(e, invoker, invocation);
                                    throw e;
                                }
                                finally {
                                    listenableFilter.removeListener(invocation);
                                }
                            } else {
                                if (!(filter instanceof Filter.Listener)) throw e;
                                Filter.Listener listener = (Filter.Listener)((Object)filter);
                                listener.onError(e, invoker, invocation);
                            }
                            throw e;
                        }
                    }

                    @Override
                    public void destroy() {
                        invoker.destroy();
                    }

                    public String toString() {
                        return invoker.toString();
                    }
                };
            }
        }
        return last;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if (UrlUtils.isRegistry(invoker.getUrl())) {
            return this.protocol.export(invoker);
        }
        return this.protocol.export(ProtocolFilterWrapper.buildInvokerChain(invoker, "service.filter", "provider"));
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if (UrlUtils.isRegistry(url)) {
            return this.protocol.refer(type, url);
        }
        return ProtocolFilterWrapper.buildInvokerChain(this.protocol.refer(type, url), "reference.filter", "consumer");
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    @Override
    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }
}

