/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.proxy.BaseMetadataServiceProxyFactory;
import org.apache.dubbo.registry.client.metadata.proxy.MetadataServiceProxyFactory;

public class CompositeMetadataServiceProxyFactory
extends BaseMetadataServiceProxyFactory {
    private static final Logger logger = LoggerFactory.getLogger(CompositeMetadataServiceProxyFactory.class);

    @Override
    public MetadataService createProxy(ServiceInstance serviceInstance) {
        MetadataService metadataService = (MetadataService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MetadataService.class}, (InvocationHandler)new MetadataServiceInvocationHandler(serviceInstance, this));
        return metadataService;
    }

    static class MetadataServiceInvocationHandler
    implements InvocationHandler {
        private final ServiceInstance serviceInstance;
        private final MetadataServiceProxyFactory excluded;
        private volatile List<MetadataService> metadataServices;

        MetadataServiceInvocationHandler(ServiceInstance serviceInstance, MetadataServiceProxyFactory excluded) {
            this.serviceInstance = serviceInstance;
            this.excluded = excluded;
        }

        private List<MetadataService> loadMetadataServices() {
            return ExtensionLoader.getExtensionLoader(MetadataServiceProxyFactory.class).getSupportedExtensionInstances().stream().filter(this::isRequiredFactory).map(this::getProxy).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private List<MetadataService> getMetadataServices() {
            if (this.metadataServices == null) {
                this.metadataServices = this.loadMetadataServices();
                if (this.metadataServices.isEmpty()) {
                    throw new IllegalStateException(String.format("No valid proxy of %s can't be loaded.", MetadataService.class.getName()));
                }
            }
            return this.metadataServices;
        }

        private boolean isRequiredFactory(MetadataServiceProxyFactory factory) {
            return !factory.equals(this.excluded);
        }

        private MetadataService getProxy(MetadataServiceProxyFactory factory) {
            MetadataService metadataService;
            block2: {
                metadataService = null;
                try {
                    metadataService = factory.getProxy(this.serviceInstance);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block2;
                    logger.error(String.format("The proxy of %s can't be gotten by %s [from : %s].", MetadataService.class.getName(), factory.getClass().getName(), this.serviceInstance.toString()));
                }
            }
            return metadataService;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke(proxy, args);
            }
            Object result = null;
            for (MetadataService metadataService : this.getMetadataServices()) {
                try {
                    result = method.invoke((Object)metadataService, args);
                    if (result == null) continue;
                    break;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error(String.format("MetadataService[type : %s] executes failed.", metadataService.getClass().getName()), e);
                }
            }
            return result;
        }
    }
}

