/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.zookeeper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;

@Deprecated
public class ZookeeperMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperMetadataReport.class);
    private final String root;
    final ZookeeperClient zkClient;

    public ZookeeperMetadataReport(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", "dubbo");
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient = zookeeperTransporter.connect(url);
    }

    String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    @Override
    protected void doSaveMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
        this.zkClient.create(this.getNodePath(metadataIdentifier), URL.encode(url.toFullString()), false);
    }

    @Override
    protected void doRemoveMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        this.zkClient.delete(this.getNodePath(metadataIdentifier));
    }

    @Override
    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.zkClient.getContent(this.getNodePath(metadataIdentifier));
        if (StringUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode(content)));
    }

    @Override
    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urls) {
        this.zkClient.create(this.getNodePath(subscriberMetadataIdentifier), urls, false);
    }

    @Override
    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath(subscriberMetadataIdentifier));
    }

    @Override
    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath(metadataIdentifier));
    }

    private void storeMetadata(MetadataIdentifier metadataIdentifier, String v) {
        this.zkClient.create(this.getNodePath(metadataIdentifier), v, false);
    }

    String getNodePath(BaseMetadataIdentifier metadataIdentifier) {
        return this.toRootDir() + metadataIdentifier.getUniqueKey(KeyTypeEnum.PATH);
    }

    @Override
    public boolean saveExportedURLs(String serviceName, String exportedServicesRevision, String exportedURLsContent) {
        String path = this.buildExportedURLsMetadataPath(serviceName, exportedServicesRevision);
        this.zkClient.create(path, exportedURLsContent, false);
        return true;
    }

    @Override
    public String getExportedURLsContent(String serviceName, String exportedServicesRevision) {
        String path = this.buildExportedURLsMetadataPath(serviceName, exportedServicesRevision);
        String content = this.zkClient.getContent(path);
        return content;
    }

    private String buildExportedURLsMetadataPath(String serviceName, String exportedServicesRevision) {
        return this.buildPath("metadata", "exported-urls", serviceName, exportedServicesRevision);
    }

    private String buildPath(String ... paths) {
        return PathUtils.buildPath(this.toRootDir(), paths);
    }
}

