/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store;

import java.util.SortedSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.URLRevisionResolver;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.store.AbstractAbstractWritableMetadataService;
import org.apache.dubbo.metadata.store.InMemoryWritableMetadataService;

public class RemoteWritableMetadataService
extends AbstractAbstractWritableMetadataService {
    private final InMemoryWritableMetadataService writableMetadataServiceDelegate = (InMemoryWritableMetadataService)WritableMetadataService.getDefaultExtension();
    private final URLRevisionResolver urlRevisionResolver = URLRevisionResolver.INSTANCE;

    public MetadataReport getMetadataReport() {
        return MetadataReportInstance.getMetadataReport(true);
    }

    @Override
    protected void publishConsumerParameters(URL consumerURL) {
        this.getMetadataReport().storeConsumerMetadata(new MetadataIdentifier(consumerURL.getServiceInterface(), consumerURL.getParameter("version"), consumerURL.getParameter("group"), "consumer", consumerURL.getParameter("application")), consumerURL.getParameters());
    }

    @Override
    protected void publishProviderServiceDefinition(URL providerURL) {
        try {
            String interfaceName = providerURL.getParameter("interface");
            if (StringUtils.isNotEmpty(interfaceName)) {
                Class<?> interfaceClass = Class.forName(interfaceName);
                FullServiceDefinition fullServiceDefinition = ServiceDefinitionBuilder.buildFullDefinition(interfaceClass, providerURL.getParameters());
                this.getMetadataReport().storeProviderMetadata(new MetadataIdentifier(providerURL.getServiceInterface(), providerURL.getParameter("version"), providerURL.getParameter("group"), "provider", providerURL.getParameter("application")), fullServiceDefinition);
                return;
            }
            this.logger.error("publishProvider interfaceName is empty . url: " + providerURL.toFullString());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("publishProvider getServiceDescriptor error. url: " + providerURL.toFullString(), e);
        }
    }

    @Override
    public boolean exportURL(URL url) {
        return this.writableMetadataServiceDelegate.exportURL(url);
    }

    @Override
    public boolean unexportURL(URL url) {
        return this.writableMetadataServiceDelegate.unexportURL(url);
    }

    @Override
    public boolean subscribeURL(URL url) {
        return this.writableMetadataServiceDelegate.subscribeURL(url);
    }

    @Override
    public boolean unsubscribeURL(URL url) {
        return this.writableMetadataServiceDelegate.unsubscribeURL(url);
    }

    @Override
    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        return this.writableMetadataServiceDelegate.getExportedURLs(serviceInterface, group, version, protocol);
    }

    @Override
    public String getServiceDefinition(String serviceKey) {
        return this.writableMetadataServiceDelegate.getServiceDefinition(serviceKey);
    }

    @Override
    public SortedSet<String> getSubscribedURLs() {
        return this.writableMetadataServiceDelegate.getSubscribedURLs();
    }
}

