/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.store.AbstractAbstractWritableMetadataService;

public class InMemoryWritableMetadataService
extends AbstractAbstractWritableMetadataService {
    private final Lock lock = new ReentrantLock();
    private final ConcurrentNavigableMap<String, SortedSet<URL>> exportedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    private final ConcurrentNavigableMap<String, SortedSet<URL>> subscribedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    private final ConcurrentNavigableMap<String, String> serviceDefinitions = new ConcurrentSkipListMap<String, String>();

    @Override
    public SortedSet<String> getSubscribedURLs() {
        return this.getAllUnmodifiableServiceURLs(this.subscribedServiceURLs);
    }

    private SortedSet<String> getAllUnmodifiableServiceURLs(Map<String, SortedSet<URL>> serviceURLs) {
        TreeSet<URL> bizURLs = new TreeSet<URL>(URLComparator.INSTANCE);
        for (Map.Entry<String, SortedSet<URL>> entry : serviceURLs.entrySet()) {
            SortedSet<URL> urls = entry.getValue();
            if (urls == null) continue;
            for (URL url : urls) {
                if (MetadataService.class.getName().equals(url.getServiceInterface())) continue;
                bizURLs.add(url);
            }
        }
        return MetadataService.toSortedStrings(bizURLs);
    }

    @Override
    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        if ("*".equals(serviceInterface)) {
            return this.getAllUnmodifiableServiceURLs(this.exportedServiceURLs);
        }
        String serviceKey = URL.buildKey(serviceInterface, group, version);
        return Collections.unmodifiableSortedSet(this.getServiceURLs(this.exportedServiceURLs, serviceKey, protocol));
    }

    @Override
    public boolean exportURL(URL url) {
        return this.addURL(this.exportedServiceURLs, url);
    }

    @Override
    public boolean unexportURL(URL url) {
        return this.removeURL(this.exportedServiceURLs, url);
    }

    @Override
    public boolean subscribeURL(URL url) {
        return this.addURL(this.subscribedServiceURLs, url);
    }

    @Override
    public boolean unsubscribeURL(URL url) {
        return this.removeURL(this.subscribedServiceURLs, url);
    }

    @Override
    protected void publishServiceDefinition(String key, String json) {
        this.serviceDefinitions.put(key, json);
    }

    @Override
    public String getServiceDefinition(String serviceDefinitionKey) {
        return (String)this.serviceDefinitions.get(serviceDefinitionKey);
    }

    public Map<String, SortedSet<URL>> getExportedServiceURLs() {
        return Collections.unmodifiableSortedMap(this.exportedServiceURLs);
    }

    public Map<String, SortedSet<URL>> getSubscribedServiceURLs() {
        return Collections.unmodifiableSortedMap(this.subscribedServiceURLs);
    }

    public Map<String, String> getServiceDefinitions() {
        return Collections.unmodifiableSortedMap(this.serviceDefinitions);
    }

    boolean addURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        return this.executeMutually(() -> {
            SortedSet urls = serviceURLs.computeIfAbsent(url.getServiceKey(), this::newSortedURLs);
            return urls.add(url);
        });
    }

    boolean removeURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        return this.executeMutually(() -> {
            String key = url.getServiceKey();
            SortedSet urls = serviceURLs.getOrDefault(key, null);
            if (urls == null) {
                return true;
            }
            boolean r = urls.remove(url);
            if (urls.isEmpty()) {
                serviceURLs.remove(key);
            }
            return r;
        });
    }

    private SortedSet<URL> newSortedURLs(String serviceKey) {
        return new TreeSet<URL>(URLComparator.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeMutually(Callable<Boolean> callable) {
        boolean success = false;
        try {
            this.lock.lock();
            try {
                success = callable.call();
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return success;
    }

    private SortedSet<String> getServiceURLs(Map<String, SortedSet<URL>> exportedServiceURLs, String serviceKey, String protocol) {
        SortedSet<URL> serviceURLs = exportedServiceURLs.get(serviceKey);
        if (CollectionUtils.isEmpty(serviceURLs)) {
            return Collections.emptySortedSet();
        }
        return MetadataService.toSortedStrings(serviceURLs.stream().filter(url -> this.isAcceptableProtocol(protocol, (URL)url)));
    }

    private boolean isAcceptableProtocol(String protocol, URL url) {
        return protocol == null || protocol.equals(url.getParameter("protocol")) || protocol.equals(url.getProtocol());
    }

    static class URLComparator
    implements Comparator<URL> {
        public static final URLComparator INSTANCE = new URLComparator();

        URLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toFullString().compareTo(o2.toFullString());
        }
    }
}

