/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.support.ConfigCenterBasedMetadataReport;

public abstract class ConfigCenterBasedMetadataReportFactory
implements MetadataReportFactory {
    private static final String URL_PATH = MetadataReport.class.getName();
    private static final Map<String, ConfigCenterBasedMetadataReport> metadataReportCache = new ConcurrentHashMap<String, ConfigCenterBasedMetadataReport>();
    private final KeyTypeEnum keyType;

    public ConfigCenterBasedMetadataReportFactory(KeyTypeEnum keyType) {
        if (keyType == null) {
            throw new NullPointerException("The keyType argument must not be null!");
        }
        this.keyType = keyType;
    }

    @Override
    public ConfigCenterBasedMetadataReport getMetadataReport(URL url) {
        url = url.setPath(URL_PATH);
        URL actualURL = this.resolveURLParameters(url);
        String key = actualURL.toServiceString();
        return metadataReportCache.computeIfAbsent(key, k -> new ConfigCenterBasedMetadataReport(actualURL, this.keyType));
    }

    private URL resolveURLParameters(URL url) {
        URL resolvedURL = url.removeParameters("export", "refer");
        if (KeyTypeEnum.PATH.equals((Object)this.getKeyType()) && StringUtils.isBlank(resolvedURL.getParameter("dubbo.config-center.root-path"))) {
            resolvedURL = resolvedURL.addParameter("dubbo.config-center.root-path", StringUtils.SLASH);
        }
        return resolvedURL;
    }

    protected KeyTypeEnum getKeyType() {
        return this.keyType;
    }
}

