/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.URLRevisionResolver;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;

public interface MetadataReport
extends AutoCloseable {
    public void storeProviderMetadata(MetadataIdentifier var1, ServiceDefinition var2);

    public void storeConsumerMetadata(MetadataIdentifier var1, Map<String, String> var2);

    @Deprecated
    default public void saveServiceMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
    }

    @Deprecated
    default public void removeServiceMetadata(ServiceMetadataIdentifier metadataIdentifier) {
    }

    @Deprecated
    default public List<String> getExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        return Collections.emptyList();
    }

    public void saveSubscribedData(SubscriberMetadataIdentifier var1, Collection<String> var2);

    public Collection<String> getSubscribedURLs(SubscriberMetadataIdentifier var1);

    public String getServiceDefinition(MetadataIdentifier var1);

    default public boolean saveExportedURLs(SortedSet<String> exportedURLs) {
        return this.saveExportedURLs(ApplicationModel.getName(), exportedURLs);
    }

    default public boolean saveExportedURLs(String serviceName, SortedSet<String> exportedURLs) {
        return this.saveExportedURLs(serviceName, new URLRevisionResolver().resolve((Iterable<String>)exportedURLs), exportedURLs);
    }

    default public boolean saveExportedURLs(String serviceName, String exportedServicesRevision, SortedSet<String> exportedURLs) {
        Gson gson = new Gson();
        String content = gson.toJson(exportedURLs);
        return this.saveExportedURLs(serviceName, exportedServicesRevision, content);
    }

    default public boolean saveExportedURLs(String serviceName, String exportedServicesRevision, String exportedURLsContent) {
        return true;
    }

    default public SortedSet<String> getExportedURLs(String serviceName, String exportedServicesRevision) {
        String exportedURLsContent = this.getExportedURLsContent(serviceName, exportedServicesRevision);
        if (StringUtils.isBlank(exportedURLsContent)) {
            return Collections.emptySortedSet();
        }
        Gson gson = new Gson();
        return (SortedSet)gson.fromJson(exportedURLsContent, TreeSet.class);
    }

    default public String getExportedURLsContent(String serviceName, String exportedServicesRevision) {
        return null;
    }
}

