/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.ServiceNameMapping;

public class CompositeServiceNameMapping
implements ServiceNameMapping {
    private volatile List<ServiceNameMapping> serviceNameMappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceNameMapping> getServiceNameMappings() {
        if (this.serviceNameMappings == null) {
            CompositeServiceNameMapping compositeServiceNameMapping = this;
            synchronized (compositeServiceNameMapping) {
                if (this.serviceNameMappings == null) {
                    Set<ServiceNameMapping> serviceNameMappings = this.loadAllServiceNameMappings();
                    this.removeSelf(serviceNameMappings);
                    this.serviceNameMappings = new LinkedList<ServiceNameMapping>(serviceNameMappings);
                }
            }
        }
        return this.serviceNameMappings;
    }

    private Set<ServiceNameMapping> loadAllServiceNameMappings() {
        return ExtensionLoader.getExtensionLoader(ServiceNameMapping.class).getSupportedExtensionInstances();
    }

    private void removeSelf(Set<ServiceNameMapping> serviceNameMappings) {
        Iterator<ServiceNameMapping> iterator = serviceNameMappings.iterator();
        while (iterator.hasNext()) {
            ServiceNameMapping serviceNameMapping = iterator.next();
            if (!this.getClass().equals(serviceNameMapping.getClass())) continue;
            iterator.remove();
        }
    }

    @Override
    public void map(URL exportedURL) {
        List<ServiceNameMapping> serviceNameMappings = this.getServiceNameMappings();
        serviceNameMappings.forEach(serviceNameMapping -> serviceNameMapping.map(exportedURL));
    }

    @Override
    public Set<String> get(URL subscribedURL) {
        ServiceNameMapping serviceNameMapping;
        List<ServiceNameMapping> serviceNameMappings = this.getServiceNameMappings();
        Set<String> serviceNames = null;
        Iterator<ServiceNameMapping> iterator = serviceNameMappings.iterator();
        while (iterator.hasNext() && !CollectionUtils.isNotEmpty(serviceNames = (serviceNameMapping = iterator.next()).get(subscribedURL))) {
        }
        return serviceNames == null ? Collections.emptySet() : Collections.unmodifiableSet(serviceNames);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

