/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.SortedSet;
import org.apache.dubbo.config.metadata.AbstractMetadataServiceExporter;
import org.apache.dubbo.metadata.MetadataServiceType;
import org.apache.dubbo.metadata.URLRevisionResolver;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;

public class RemoteMetadataServiceExporter
extends AbstractMetadataServiceExporter {
    private final URLRevisionResolver urlRevisionResolver = URLRevisionResolver.INSTANCE;

    public RemoteMetadataServiceExporter() {
        super("remote", Integer.MAX_VALUE, MetadataServiceType.REMOTE, MetadataServiceType.COMPOSITE);
    }

    @Override
    protected void doExport() throws Exception {
        WritableMetadataService metadataServiceDelegate = WritableMetadataService.getDefaultExtension();
        if (this.publishServiceMetadata(metadataServiceDelegate)) {
            this.publicConsumerMetadata(metadataServiceDelegate);
        }
    }

    private boolean publishServiceMetadata(WritableMetadataService metadataServiceDelegate) {
        String serviceName = metadataServiceDelegate.serviceName();
        SortedSet<String> exportedURLs = metadataServiceDelegate.getExportedURLs();
        String revision = this.urlRevisionResolver.resolve((Iterable<String>)exportedURLs);
        return this.getMetadataReport().saveExportedURLs(serviceName, revision, exportedURLs);
    }

    private boolean publicConsumerMetadata(WritableMetadataService metadataServiceDelegate) {
        String serviceName = metadataServiceDelegate.serviceName();
        SortedSet<String> subscribedURLs = metadataServiceDelegate.getSubscribedURLs();
        String revision = this.urlRevisionResolver.resolve((Iterable<String>)subscribedURLs);
        this.getMetadataReport().saveSubscribedData(new SubscriberMetadataIdentifier(serviceName, revision), subscribedURLs);
        return true;
    }

    private MetadataReport getMetadataReport() {
        return MetadataReportInstance.getMetadataReport(true);
    }

    @Override
    protected void doUnexport() throws Exception {
    }
}

