/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.metadata.AbstractMetadataServiceExporter;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceType;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter
extends AbstractMetadataServiceExporter {
    private volatile ServiceConfig<MetadataService> serviceConfig;

    public ConfigurableMetadataServiceExporter() {
        super("local", Integer.MIN_VALUE, EnumSet.allOf(MetadataServiceType.class));
    }

    @Override
    protected void doExport() throws Exception {
        ServiceConfig<WritableMetadataService> serviceConfig = new ServiceConfig<WritableMetadataService>();
        serviceConfig.setApplication(this.getApplicationConfig());
        serviceConfig.setRegistries(this.getRegistries());
        serviceConfig.setProtocol(this.generateMetadataProtocol());
        serviceConfig.setInterface(MetadataService.class);
        serviceConfig.setRef(this.metadataService);
        serviceConfig.setGroup(this.getApplicationConfig().getName());
        serviceConfig.setVersion(this.metadataService.version());
        serviceConfig.export();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The MetadataService exports urls : " + serviceConfig.getExportedUrls());
        }
        this.serviceConfig = serviceConfig;
    }

    @Override
    protected void doUnexport() throws Exception {
        if (this.serviceConfig != null) {
            this.serviceConfig.unexport();
        }
    }

    @Override
    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }

    @Override
    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported();
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    private ApplicationConfig getApplicationConfig() {
        return ApplicationModel.getConfigManager().getApplication().get();
    }

    private List<RegistryConfig> getRegistries() {
        return new ArrayList<RegistryConfig>(ApplicationModel.getConfigManager().getRegistries());
    }

    private ProtocolConfig generateMetadataProtocol() {
        ProtocolConfig defaultProtocol = new ProtocolConfig();
        defaultProtocol.setName("dubbo");
        defaultProtocol.setPort(-1);
        return defaultProtocol;
    }
}

