/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.metadata.MetadataServiceType;
import org.apache.dubbo.metadata.WritableMetadataService;

public abstract class AbstractMetadataServiceExporter
implements MetadataServiceExporter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final WritableMetadataService metadataService;
    private final int priority;
    private final Set<MetadataServiceType> supportedMetadataServiceTypes;
    private volatile boolean exported = false;

    public AbstractMetadataServiceExporter(String metadataType, int priority, MetadataServiceType supportMetadataServiceType, MetadataServiceType ... otherSupportMetadataServiceTypes) {
        this(metadataType, priority, EnumSet.of(supportMetadataServiceType, otherSupportMetadataServiceTypes));
    }

    public AbstractMetadataServiceExporter(String metadataType, int priority, Set<MetadataServiceType> supportedMetadataServiceTypes) {
        this.metadataService = WritableMetadataService.getExtension(metadataType);
        this.priority = priority;
        this.supportedMetadataServiceTypes = supportedMetadataServiceTypes;
    }

    @Override
    public final MetadataServiceExporter export() {
        if (!this.isExported()) {
            try {
                this.doExport();
                this.exported = true;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Exporting the MetadataService fails", e);
                }
                this.exported = false;
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The MetadataService has been exported : " + this.getExportedURLs());
        }
        return this;
    }

    @Override
    public final MetadataServiceExporter unexport() {
        block3: {
            if (this.isExported()) {
                try {
                    this.doUnexport();
                    this.exported = false;
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("UnExporting the MetadataService fails", e);
                }
            }
        }
        return this;
    }

    @Override
    public List<URL> getExportedURLs() {
        return this.metadataService.getExportedURLs().stream().map(URL::valueOf).collect(Collectors.toList());
    }

    @Override
    public boolean isExported() {
        return this.exported;
    }

    @Override
    public final boolean supports(String metadataType) {
        MetadataServiceType metadataServiceType = MetadataServiceType.getOrDefault(metadataType);
        return this.supportedMetadataServiceTypes.contains((Object)metadataServiceType);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected abstract void doExport() throws Exception;

    protected abstract void doUnexport() throws Exception;

    public WritableMetadataService getMetadataService() {
        return this.metadataService;
    }
}

