/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.dependencies.io.grpc;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.shenyu.dependencies.io.grpc.BinaryLog;
import org.apache.shenyu.dependencies.io.grpc.BindableService;
import org.apache.shenyu.dependencies.io.grpc.CompressorRegistry;
import org.apache.shenyu.dependencies.io.grpc.DecompressorRegistry;
import org.apache.shenyu.dependencies.io.grpc.ExperimentalApi;
import org.apache.shenyu.dependencies.io.grpc.HandlerRegistry;
import org.apache.shenyu.dependencies.io.grpc.Server;
import org.apache.shenyu.dependencies.io.grpc.ServerCallExecutorSupplier;
import org.apache.shenyu.dependencies.io.grpc.ServerInterceptor;
import org.apache.shenyu.dependencies.io.grpc.ServerProvider;
import org.apache.shenyu.dependencies.io.grpc.ServerServiceDefinition;
import org.apache.shenyu.dependencies.io.grpc.ServerStreamTracer;
import org.apache.shenyu.dependencies.io.grpc.ServerTransportFilter;

public abstract class ServerBuilder<T extends ServerBuilder<T>> {
    public static ServerBuilder<?> forPort(int port) {
        return ServerProvider.provider().builderForPort(port);
    }

    public abstract T directExecutor();

    public abstract T executor(@Nullable Executor var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8274")
    public T callExecutor(ServerCallExecutorSupplier executorSupplier) {
        return this.thisT();
    }

    public abstract T addService(ServerServiceDefinition var1);

    public abstract T addService(BindableService var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7925")
    public final T addServices(List<ServerServiceDefinition> services) {
        Preconditions.checkNotNull(services, (Object)"services");
        for (ServerServiceDefinition service : services) {
            this.addService(service);
        }
        return this.thisT();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/3117")
    public T intercept(ServerInterceptor interceptor) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2132")
    public T addTransportFilter(ServerTransportFilter filter) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        throw new UnsupportedOperationException();
    }

    public abstract T fallbackHandlerRegistry(@Nullable HandlerRegistry var1);

    public abstract T useTransportSecurity(File var1, File var2);

    public T useTransportSecurity(InputStream certChain, InputStream privateKey) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T decompressorRegistry(@Nullable DecompressorRegistry var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T compressorRegistry(@Nullable CompressorRegistry var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/3706")
    public T handshakeTimeout(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public T maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument((bytes >= 0 ? 1 : 0) != 0, (Object)"bytes must be >= 0");
        return this.thisT();
    }

    public T maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        return this.thisT();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4017")
    public T setBinaryLog(BinaryLog binaryLog) {
        throw new UnsupportedOperationException();
    }

    public abstract Server build();

    private T thisT() {
        ServerBuilder thisT = this;
        return (T)thisT;
    }
}

