/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.dependencies.io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shenyu.dependencies.io.grpc.Attributes;
import org.apache.shenyu.dependencies.io.grpc.CallOptions;
import org.apache.shenyu.dependencies.io.grpc.ExperimentalApi;
import org.apache.shenyu.dependencies.io.grpc.Internal;
import org.apache.shenyu.dependencies.io.grpc.Metadata;
import org.apache.shenyu.dependencies.io.grpc.StreamTracer;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
@ThreadSafe
public abstract class ClientStreamTracer
extends StreamTracer {
    public void streamCreated(Attributes transportAttrs, Metadata headers) {
    }

    public void outboundHeaders() {
    }

    public void inboundHeaders() {
    }

    public void inboundTrailers(Metadata trailers) {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public static final class StreamInfo {
        private final Attributes transportAttrs;
        private final CallOptions callOptions;
        private final int previousAttempts;
        private final boolean isTransparentRetry;

        StreamInfo(Attributes transportAttrs, CallOptions callOptions, int previousAttempts, boolean isTransparentRetry) {
            this.transportAttrs = (Attributes)Preconditions.checkNotNull((Object)transportAttrs, (Object)"transportAttrs");
            this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions, (Object)"callOptions");
            this.previousAttempts = previousAttempts;
            this.isTransparentRetry = isTransparentRetry;
        }

        @Deprecated
        public Attributes getTransportAttrs() {
            return this.transportAttrs;
        }

        public CallOptions getCallOptions() {
            return this.callOptions;
        }

        public int getPreviousAttempts() {
            return this.previousAttempts;
        }

        public boolean isTransparentRetry() {
            return this.isTransparentRetry;
        }

        public Builder toBuilder() {
            return new Builder().setCallOptions(this.callOptions).setTransportAttrs(this.transportAttrs).setPreviousAttempts(this.previousAttempts).setIsTransparentRetry(this.isTransparentRetry);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("transportAttrs", (Object)this.transportAttrs).add("callOptions", (Object)this.callOptions).add("previousAttempts", this.previousAttempts).add("isTransparentRetry", this.isTransparentRetry).toString();
        }

        public static final class Builder {
            private Attributes transportAttrs = Attributes.EMPTY;
            private CallOptions callOptions = CallOptions.DEFAULT;
            private int previousAttempts;
            private boolean isTransparentRetry;

            Builder() {
            }

            @Deprecated
            public Builder setTransportAttrs(Attributes transportAttrs) {
                this.transportAttrs = (Attributes)Preconditions.checkNotNull((Object)transportAttrs, (Object)"transportAttrs cannot be null");
                return this;
            }

            public Builder setCallOptions(CallOptions callOptions) {
                this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions, (Object)"callOptions cannot be null");
                return this;
            }

            public Builder setPreviousAttempts(int previousAttempts) {
                this.previousAttempts = previousAttempts;
                return this;
            }

            public Builder setIsTransparentRetry(boolean isTransparentRetry) {
                this.isTransparentRetry = isTransparentRetry;
                return this;
            }

            public StreamInfo build() {
                return new StreamInfo(this.transportAttrs, this.callOptions, this.previousAttempts, this.isTransparentRetry);
            }
        }
    }

    @Internal
    public static abstract class InternalLimitedInfoFactory
    extends Factory {
    }

    public static abstract class Factory {
        public ClientStreamTracer newClientStreamTracer(StreamInfo info, Metadata headers) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

