/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.opentelemetry.span;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.web.server.ServerWebExchange;

public class OpenTelemetrySpanManager {
    private volatile Span lastSpan;
    private final AtomicInteger count = new AtomicInteger(0);

    public Span startAndRecord(String spanName, Map<String, String> attributesMap) {
        SpanBuilder spanBuilder = GlobalOpenTelemetry.getTracer("shenyu-agent").spanBuilder(spanName).setSpanKind(SpanKind.INTERNAL);
        Optional.ofNullable(attributesMap).ifPresent(attributes -> attributes.forEach(spanBuilder::setAttribute));
        Optional.ofNullable(this.lastSpan).ifPresent(parentSpan -> spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)parentSpan)));
        Span span = spanBuilder.startSpan();
        this.count.incrementAndGet();
        this.lastSpan = span;
        return span;
    }

    public void finish(Span span, ServerWebExchange exchange) {
        span.end();
        if (this.count.decrementAndGet() == 0) {
            exchange.getAttributes().remove("shenyu-agent");
        }
    }
}

