/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.opentelemetry.handler;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.shenyu.agent.api.entity.MethodResult;
import org.apache.shenyu.agent.api.entity.TargetObject;
import org.apache.shenyu.agent.api.handler.InstanceMethodHandler;
import org.apache.shenyu.agent.plugin.tracing.opentelemetry.span.OpenTelemetrySpanManager;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class OpenTelemetryPluginCommonHandler
implements InstanceMethodHandler {
    @Override
    public void before(TargetObject target, Method method, Object[] args, MethodResult result) {
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        OpenTelemetrySpanManager spanManager = exchange.getAttributes().getOrDefault("shenyu-agent", new OpenTelemetrySpanManager());
        HashMap<String, String> attributesMap = new HashMap<String, String>(8);
        attributesMap.put("component", "shenyu");
        for (int i = 2; i < args.length; ++i) {
            attributesMap.put(args[i].getClass().getName(), GsonUtils.getGson().toJson(args[i]));
        }
        Span span = spanManager.startAndRecord(method.getDeclaringClass().getSimpleName(), attributesMap);
        exchange.getAttributes().put("shenyu-agent", spanManager);
        target.setContext(span);
    }

    @Override
    public Object after(TargetObject target, Method method, Object[] args, MethodResult methodResult, Object result) {
        Span span = (Span)target.getContext();
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        OpenTelemetrySpanManager manager = (OpenTelemetrySpanManager)exchange.getAttributes().get("shenyu-agent");
        if (result instanceof Mono) {
            return ((Mono)result).doFinally(s -> manager.finish(span, exchange));
        }
        manager.finish(span, exchange);
        return result;
    }

    @Override
    public void onThrowing(TargetObject target, Method method, Object[] args, Throwable throwable) {
        Span span = (Span)target.getContext();
        span.setStatus(StatusCode.ERROR).recordException(throwable);
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        OpenTelemetrySpanManager manager = (OpenTelemetrySpanManager)exchange.getAttributes().get("shenyu-agent");
        manager.finish(span, exchange);
    }
}

