/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.opentelemetry.handler;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import org.apache.shenyu.agent.api.entity.MethodResult;
import org.apache.shenyu.agent.api.entity.TargetObject;
import org.apache.shenyu.agent.api.handler.InstanceMethodHandler;
import org.apache.shenyu.agent.plugin.tracing.opentelemetry.span.OpenTelemetrySpanManager;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class OpenTelemetryGlobalPluginHandler
implements InstanceMethodHandler {
    @Override
    public void before(TargetObject target, Method method, Object[] args, MethodResult result) {
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        OpenTelemetrySpanManager spanManager = exchange.getAttributes().getOrDefault("shenyu-agent", new OpenTelemetrySpanManager());
        HashMap<String, String> attributesMap = new HashMap<String, String>(4);
        attributesMap.put("component", "shenyu");
        attributesMap.put("http.url", exchange.getRequest().getURI().toString());
        Optional.ofNullable(exchange.getRequest().getMethod()).ifPresent(v -> attributesMap.put("http.status_code", v.toString()));
        Span span = spanManager.startAndRecord("/shenyu/root", attributesMap);
        exchange.getAttributes().put("shenyu-agent", spanManager);
        target.setContext(span);
    }

    @Override
    public Object after(TargetObject target, Method method, Object[] args, MethodResult methodResult, Object result) {
        Span span = (Span)target.getContext();
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        OpenTelemetrySpanManager manager = (OpenTelemetrySpanManager)exchange.getAttributes().get("shenyu-agent");
        if (result instanceof Mono) {
            return ((Mono)result).doFinally(s -> manager.finish(span, exchange));
        }
        manager.finish(span, exchange);
        return result;
    }

    @Override
    public void onThrowing(TargetObject target, Method method, Object[] args, Throwable throwable) {
        Span span = (Span)target.getContext();
        span.setStatus(StatusCode.ERROR).recordException(throwable);
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        OpenTelemetrySpanManager manager = (OpenTelemetrySpanManager)exchange.getAttributes().get("shenyu-agent");
        manager.finish(span, exchange);
    }
}

