/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.api.point;

import java.util.ArrayList;
import java.util.List;
import org.apache.shenyu.agent.api.point.ConstructorPointCut;
import org.apache.shenyu.agent.api.point.InstanceMethodPointCut;
import org.apache.shenyu.agent.api.point.StaticMethodPointCut;
import org.apache.shenyu.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.shenyu.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.shenyu.dependencies.net.bytebuddy.matcher.ElementMatchers;

public final class ShenyuAgentJoinPoint {
    private final String classTarget;
    private final List<ConstructorPointCut> constructorPoints;
    private final List<InstanceMethodPointCut> instanceMethodPoints;
    private final List<StaticMethodPointCut> staticMethodPoints;

    public ShenyuAgentJoinPoint(String classTarget, List<ConstructorPointCut> constructorPoints, List<InstanceMethodPointCut> instanceMethodPoints, List<StaticMethodPointCut> staticMethodPoints) {
        this.classTarget = classTarget;
        this.constructorPoints = constructorPoints;
        this.instanceMethodPoints = instanceMethodPoints;
        this.staticMethodPoints = staticMethodPoints;
    }

    public static JoinPointBuilder interceptClass(String classTarget) {
        return new JoinPointBuilder(classTarget);
    }

    public String getClassTarget() {
        return this.classTarget;
    }

    public List<ConstructorPointCut> getConstructorPoints() {
        return this.constructorPoints;
    }

    public List<InstanceMethodPointCut> getInstanceMethodPoints() {
        return this.instanceMethodPoints;
    }

    public List<StaticMethodPointCut> getStaticMethodPoints() {
        return this.staticMethodPoints;
    }

    public static final class JoinPointBuilder {
        private final List<ConstructorPointCut> constructorPoints = new ArrayList<ConstructorPointCut>();
        private final List<InstanceMethodPointCut> instanceMethodPoints = new ArrayList<InstanceMethodPointCut>();
        private final List<StaticMethodPointCut> classStaticMethodPoints = new ArrayList<StaticMethodPointCut>();
        private final String classTarget;

        public JoinPointBuilder(String classTarget) {
            this.classTarget = classTarget;
        }

        public ConstructorPointBuilder onConstructor(ElementMatcher<? super MethodDescription> matcher) {
            return new ConstructorPointBuilder(this, matcher);
        }

        public InstanceMethodPointBuilder aroundInstanceMethod(ElementMatcher<? super MethodDescription> matcher) {
            return new InstanceMethodPointBuilder(this, matcher);
        }

        public StaticMethodPointBuilder aroundStaticMethod(ElementMatcher<? super MethodDescription> matcher) {
            return new StaticMethodPointBuilder(this, matcher);
        }

        public ShenyuAgentJoinPoint install() {
            return new ShenyuAgentJoinPoint(this.classTarget, this.constructorPoints, this.instanceMethodPoints, this.classStaticMethodPoints);
        }

        public static final class ConstructorPointBuilder {
            private final JoinPointBuilder builder;
            private final ElementMatcher<? super MethodDescription> matcher;
            private List<String> handlers;

            private ConstructorPointBuilder(JoinPointBuilder builder, ElementMatcher<? super MethodDescription> matcher) {
                this.builder = builder;
                this.matcher = ElementMatchers.isConstructor().and(matcher);
            }

            public ConstructorPointBuilder handlers(List<String> handlers) {
                this.handlers = handlers;
                return this;
            }

            public JoinPointBuilder build() {
                this.builder.constructorPoints.add(new ConstructorPointCut(this.matcher, this.handlers));
                return this.builder;
            }
        }

        public static final class StaticMethodPointBuilder {
            private final JoinPointBuilder builder;
            private List<String> handlers;
            private final ElementMatcher<? super MethodDescription> matcher;

            private StaticMethodPointBuilder(JoinPointBuilder builder, ElementMatcher<? super MethodDescription> matcher) {
                this.builder = builder;
                this.matcher = ElementMatchers.isStatic().and(matcher);
            }

            public StaticMethodPointBuilder handlers(List<String> handlers) {
                this.handlers = handlers;
                return this;
            }

            public JoinPointBuilder build() {
                this.builder.classStaticMethodPoints.add(new StaticMethodPointCut(this.matcher, this.handlers));
                return this.builder;
            }
        }

        public static final class InstanceMethodPointBuilder {
            private final JoinPointBuilder builder;
            private List<String> handlers;
            private final ElementMatcher<? super MethodDescription> matcher;

            private InstanceMethodPointBuilder(JoinPointBuilder builder, ElementMatcher<? super MethodDescription> matcher) {
                this.builder = builder;
                this.matcher = matcher;
            }

            public InstanceMethodPointBuilder handlers(List<String> handlers) {
                this.handlers = handlers;
                return this;
            }

            public JoinPointBuilder build() {
                this.builder.instanceMethodPoints.add(new InstanceMethodPointCut(this.matcher, this.handlers));
                return this.builder;
            }
        }
    }
}

