/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

final class AttributeUtil {
    private AttributeUtil() {
    }

    static Attributes applyAttributesLimit(Attributes attributes, int countLimit, int lengthLimit) {
        if (attributes.isEmpty() || attributes.size() <= countLimit) {
            if (lengthLimit == Integer.MAX_VALUE) {
                return attributes;
            }
            boolean allValidLength = AttributeUtil.allMatch(attributes.asMap().values(), value -> AttributeUtil.isValidLength(value, lengthLimit));
            if (allValidLength) {
                return attributes;
            }
        }
        AttributesBuilder result = Attributes.builder();
        int i = 0;
        for (Map.Entry<AttributeKey<?>, Object> entry : attributes.asMap().entrySet()) {
            if (i >= countLimit) break;
            result.put(entry.getKey(), AttributeUtil.applyAttributeLengthLimit(entry.getValue(), lengthLimit));
            ++i;
        }
        return result.build();
    }

    private static boolean isValidLength(Object value, int lengthLimit) {
        if (value instanceof List) {
            return AttributeUtil.allMatch((List)value, entry -> AttributeUtil.isValidLength(entry, lengthLimit));
        }
        if (value instanceof String) {
            return ((String)value).length() < lengthLimit;
        }
        return true;
    }

    private static <T> boolean allMatch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T value : iterable) {
            if (predicate.test(value)) continue;
            return false;
        }
        return true;
    }

    static Object applyAttributeLengthLimit(Object value, int lengthLimit) {
        if (lengthLimit == Integer.MAX_VALUE) {
            return value;
        }
        if (value instanceof List) {
            List values = (List)value;
            ArrayList<Object> response = new ArrayList<Object>(values.size());
            for (Object entry : values) {
                response.add(AttributeUtil.applyAttributeLengthLimit(entry, lengthLimit));
            }
            return response;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.length() < lengthLimit ? value : str.substring(0, lengthLimit);
        }
        return value;
    }
}

