/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.shenyu.dependencies.zipkin2.Span;
import org.apache.shenyu.dependencies.zipkin2.codec.BytesEncoder;
import org.apache.shenyu.dependencies.zipkin2.codec.SpanBytesEncoder;
import org.apache.shenyu.dependencies.zipkin2.reporter.Sender;
import org.apache.shenyu.dependencies.zipkin2.reporter.okhttp3.OkHttpSender;

public final class ZipkinSpanExporterBuilder {
    private BytesEncoder<Span> encoder = SpanBytesEncoder.JSON_V2;
    @Nullable
    private Sender sender;
    private String endpoint = "http://localhost:9411/api/v2/spans";
    private long readTimeoutMillis = TimeUnit.SECONDS.toMillis(10L);

    public ZipkinSpanExporterBuilder setSender(Sender sender) {
        Objects.requireNonNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public ZipkinSpanExporterBuilder setEncoder(BytesEncoder<Span> encoder) {
        Objects.requireNonNull(encoder, "encoder");
        this.encoder = encoder;
        return this;
    }

    public ZipkinSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = endpoint;
        return this;
    }

    public ZipkinSpanExporterBuilder setReadTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.readTimeoutMillis = unit.toMillis(timeout);
        return this;
    }

    public ZipkinSpanExporterBuilder setReadTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.setReadTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    public ZipkinSpanExporter build() {
        Sender sender = this.sender;
        if (sender == null) {
            sender = OkHttpSender.newBuilder().endpoint(this.endpoint).readTimeout((int)this.readTimeoutMillis).build();
        }
        return new ZipkinSpanExporter(this.encoder, sender);
    }
}

