/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import com.google.common.util.concurrent.ListenableFuture;
import io.opentelemetry.exporter.otlp.internal.grpc.MarshalerInputStream;
import io.opentelemetry.exporter.otlp.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.otlp.internal.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.trace.ExportTraceServiceResponse;
import java.io.InputStream;
import org.apache.shenyu.dependencies.io.grpc.CallOptions;
import org.apache.shenyu.dependencies.io.grpc.Channel;
import org.apache.shenyu.dependencies.io.grpc.MethodDescriptor;
import org.apache.shenyu.dependencies.io.grpc.stub.ClientCalls;

final class MarshalerTraceServiceGrpc {
    private static final String SERVICE_NAME = "opentelemetry.proto.collector.trace.v1.TraceService";
    private static final MethodDescriptor.Marshaller<TraceRequestMarshaler> REQUEST_MARSHALLER = new MethodDescriptor.Marshaller<TraceRequestMarshaler>(){

        @Override
        public InputStream stream(TraceRequestMarshaler value) {
            return new MarshalerInputStream(value);
        }

        @Override
        public TraceRequestMarshaler parse(InputStream stream) {
            throw new UnsupportedOperationException("Only for serializing");
        }
    };
    private static final MethodDescriptor.Marshaller<ExportTraceServiceResponse> RESPONSE_MARSHALER = new MethodDescriptor.Marshaller<ExportTraceServiceResponse>(){

        @Override
        public InputStream stream(ExportTraceServiceResponse value) {
            throw new UnsupportedOperationException("Only for parsing");
        }

        @Override
        public ExportTraceServiceResponse parse(InputStream stream) {
            return ExportTraceServiceResponse.INSTANCE;
        }
    };
    private static final MethodDescriptor<TraceRequestMarshaler, ExportTraceServiceResponse> getExportMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName("opentelemetry.proto.collector.trace.v1.TraceService", "Export")).setRequestMarshaller(REQUEST_MARSHALLER).setResponseMarshaller(RESPONSE_MARSHALER).build();

    static TraceServiceFutureStub newFutureStub(Channel channel) {
        return (TraceServiceFutureStub)TraceServiceFutureStub.newStub((x$0, x$1) -> new TraceServiceFutureStub(x$0, x$1), (Channel)channel);
    }

    private MarshalerTraceServiceGrpc() {
    }

    static final class TraceServiceFutureStub
    extends MarshalerServiceStub<TraceRequestMarshaler, ExportTraceServiceResponse, TraceServiceFutureStub> {
        private TraceServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TraceServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new TraceServiceFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<ExportTraceServiceResponse> export(TraceRequestMarshaler request) {
            return ClientCalls.futureUnaryCall(this.getChannel().newCall(getExportMethod, this.getCallOptions()), (Object)request);
        }
    }
}

