/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.grpc.DefaultGrpcExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.otlp.internal.grpc.OkHttpGrpcExporterBuilder;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.shenyu.dependencies.io.grpc.ManagedChannel;

final class GrpcExporterUtil {
    private static final boolean USE_OKHTTP;

    static <T extends Marshaler> GrpcExporterBuilder<T> exporterBuilder(String type, long defaultTimeoutSecs, URI defaultEndpoint, Supplier<Function<ManagedChannel, MarshalerServiceStub<T, ?, ?>>> stubFactory, String grpcServiceName, String grpcEndpointPath) {
        if (USE_OKHTTP) {
            return new OkHttpGrpcExporterBuilder(type, grpcEndpointPath, defaultTimeoutSecs, defaultEndpoint);
        }
        return new DefaultGrpcExporterBuilder<T>(type, stubFactory.get(), defaultTimeoutSecs, defaultEndpoint, grpcServiceName);
    }

    private GrpcExporterUtil() {
    }

    static {
        boolean useOkhttp = true;
        try {
            Class.forName("org.apache.shenyu.dependencies.io.grpc.stub.AbstractStub");
            useOkhttp = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USE_OKHTTP = useOkhttp;
    }
}

