/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.otlp.internal.RetryPolicy;
import java.time.Duration;
import java.util.Objects;

public final class RetryPolicyBuilder {
    private static final int DEFAULT_MAX_ATTEMPTS = 5;
    private static final Duration DEFAULT_INITIAL_BACKOFF = Duration.ofSeconds(1L);
    private static final Duration DEFAULT_MAX_BACKOFF = Duration.ofSeconds(5L);
    private static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;
    private int maxAttempts = 5;
    private Duration initialBackoff = DEFAULT_INITIAL_BACKOFF;
    private Duration maxBackoff = DEFAULT_MAX_BACKOFF;
    private double backoffMultiplier = 1.5;

    RetryPolicyBuilder() {
    }

    public RetryPolicyBuilder setMaxAttempts(int maxAttempts) {
        Utils.checkArgument(maxAttempts > 1 && maxAttempts < 6, "maxAttempts must be greater than 1 and less than 6");
        this.maxAttempts = maxAttempts;
        return this;
    }

    public RetryPolicyBuilder setInitialBackoff(Duration initialBackoff) {
        Objects.requireNonNull(initialBackoff, "initialBackoff");
        Utils.checkArgument(initialBackoff.toNanos() > 0L, "initialBackoff must be greater than 0");
        this.initialBackoff = initialBackoff;
        return this;
    }

    public RetryPolicyBuilder setMaxBackoff(Duration maxBackoff) {
        Objects.requireNonNull(maxBackoff, "maxBackoff");
        Utils.checkArgument(maxBackoff.toNanos() > 0L, "maxBackoff must be greater than 0");
        this.maxBackoff = maxBackoff;
        return this;
    }

    public RetryPolicyBuilder setBackoffMultiplier(double backoffMultiplier) {
        Utils.checkArgument(backoffMultiplier > 0.0, "backoffMultiplier must be greater than 0");
        this.backoffMultiplier = backoffMultiplier;
        return this;
    }

    public RetryPolicy build() {
        return RetryPolicy.create(this.maxAttempts, this.initialBackoff, this.maxBackoff, this.backoffMultiplier);
    }
}

