/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.exporter.otlp.internal.KeyValueMarshaler;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.sdk.resources.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class ResourceMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<Resource, ResourceMarshaler> RESOURCE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction<Resource, ResourceMarshaler>();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static ResourceMarshaler create(Resource resource) {
        ResourceMarshaler cached = (ResourceMarshaler)RESOURCE_MARSHALER_CACHE.get((Object)resource);
        if (cached == null) {
            RealResourceMarshaler realMarshaler = new RealResourceMarshaler(KeyValueMarshaler.createRepeated(resource.getAttributes()));
            ByteArrayOutputStream binaryBos = new ByteArrayOutputStream(realMarshaler.getBinarySerializedSize());
            try {
                realMarshaler.writeBinaryTo(binaryBos);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
            }
            String json = MarshalerUtil.preserializeJsonFields(realMarshaler);
            cached = new ResourceMarshaler(binaryBos.toByteArray(), json);
            RESOURCE_MARSHALER_CACHE.put((Object)resource, (Object)cached);
        }
        return cached;
    }

    private ResourceMarshaler(byte[] binary, String json) {
        super(binary.length);
        this.serializedBinary = binary;
        this.serializedJson = json;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealResourceMarshaler
    extends MarshalerWithSize {
        private final KeyValueMarshaler[] attributes;

        private RealResourceMarshaler(KeyValueMarshaler[] attributes) {
            super(RealResourceMarshaler.calculateSize(attributes));
            this.attributes = attributes;
        }

        @Override
        protected void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(io.opentelemetry.proto.resource.v1.internal.Resource.ATTRIBUTES, this.attributes);
        }

        private static int calculateSize(KeyValueMarshaler[] attributeMarshalers) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)io.opentelemetry.proto.resource.v1.internal.Resource.ATTRIBUTES, (Marshaler[])attributeMarshalers);
        }
    }
}

