/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundLongCounter;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;

public class ExporterMetrics {
    private static final AttributeKey<String> ATTRIBUTE_KEY_TYPE = AttributeKey.stringKey("type");
    private static final AttributeKey<Boolean> ATTRIBUTE_KEY_SUCCESS = AttributeKey.booleanKey("success");
    private final BoundLongCounter seen;
    private final BoundLongCounter success;
    private final BoundLongCounter failed;

    private ExporterMetrics(Meter meter, String type) {
        Attributes attributes = Attributes.builder().put(ATTRIBUTE_KEY_TYPE, type).build();
        this.seen = meter.counterBuilder("otlp.exporter.seen").build().bind(attributes);
        LongCounter exported = meter.counterBuilder("otlp.exporter.exported").build();
        this.success = exported.bind(attributes.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(true)).build());
        this.failed = exported.bind(attributes.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(false)).build());
    }

    public void addSeen(long value) {
        this.seen.add(value);
    }

    public void addSuccess(long value) {
        this.success.add(value);
    }

    public void addFailed(long value) {
        this.failed.add(value);
    }

    public void unbind() {
        this.seen.unbind();
        this.success.unbind();
        this.failed.unbind();
    }

    public static ExporterMetrics createGrpc(String type) {
        return new ExporterMetrics(GlobalMeterProvider.get().get("io.opentelemetry.exporters.otlp-grpc"), type);
    }

    public static ExporterMetrics createHttpProtobuf(String type) {
        return new ExporterMetrics(GlobalMeterProvider.get().get("io.opentelemetry.exporters.otlp-http"), type);
    }
}

