/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.MarshalerCollectorServiceGrpc;
import io.opentelemetry.exporter.jaeger.PostSpansRequestMarshaler;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporterBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.dependencies.io.grpc.ManagedChannel;

public final class JaegerGrpcSpanExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "jaeger.api_v2.CollectorService";
    static final String GRPC_ENDPOINT_PATH = "/jaeger.api_v2.CollectorService/PostSpans";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:14250";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:14250");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private final GrpcExporterBuilder<PostSpansRequestMarshaler> delegate = GrpcExporter.builder("span", 10L, DEFAULT_ENDPOINT, () -> MarshalerCollectorServiceGrpc::newFutureStub, "jaeger.api_v2.CollectorService", "/jaeger.api_v2.CollectorService/PostSpans");

    JaegerGrpcSpanExporterBuilder() {
    }

    public JaegerGrpcSpanExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.delegate.setTimeout(timeout);
        return this;
    }

    public JaegerGrpcSpanExporter build() {
        return new JaegerGrpcSpanExporter(this.delegate.build());
    }
}

