/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.api.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import java.io.IOException;

public class ArrayReader
extends ValueReader {
    protected final Class<?> _elementType;
    protected final ValueReader _valueReader;

    public ArrayReader(Class<?> clazz, Class<?> clazz2, ValueReader valueReader) {
        super(clazz);
        this._elementType = clazz2;
        this._valueReader = valueReader;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                return null;
            }
            throw JSONObjectException.from(jsonParser, "Unexpected token %s; should get START_ARRAY", new Object[]{jsonParser.getCurrentToken()});
        }
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(null);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyArray(this._elementType);
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonArray(this._elementType, object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildArray(this._elementType);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(null);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyArray(this._elementType);
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonArray(this._elementType, object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildArray(this._elementType);
    }
}

