/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt.handle;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.impl.JwtRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;

public class JwtPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, JwtRuleHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerPlugin(PluginData pluginData) {
        Map configMap = GsonUtils.getInstance().toObjectMap(pluginData.getConfig(), String.class);
        String secretKey = Optional.ofNullable(configMap.get("secretKey")).orElse("");
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.setSecretKey(secretKey);
        Singleton.INST.single(JwtConfig.class, (Object)jwtConfig);
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            JwtRuleHandle ruleHandle = (JwtRuleHandle)GsonUtils.getInstance().fromJson(s, JwtRuleHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)ruleHandle);
        });
    }

    public String pluginNamed() {
        return PluginEnum.JWT.getName();
    }
}

