/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt;

import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.JwtRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;
import org.apache.shenyu.plugin.jwt.exception.ThrowingFunction;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtPlugin
extends AbstractShenyuPlugin {
    private static final String TOKEN = "token";
    private static final String AUTH2_TOKEN = "Bearer";

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        JwtConfig jwtConfig = (JwtConfig)Singleton.INST.get(JwtConfig.class);
        String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
        String token = exchange.getRequest().getHeaders().getFirst(TOKEN);
        if (StringUtils.isEmpty((CharSequence)jwtConfig.getSecretKey())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SECRET_KEY_MUST_BE_CONFIGURED, null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String finalAuthorization = this.compatible(token, authorization);
        Map<String, String> jwtBody = this.checkAuthorization(finalAuthorization, jwtConfig.getSecretKey());
        if (jwtBody != null) {
            JwtRuleHandle ruleHandle = (JwtRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), JwtRuleHandle.class);
            if (ruleHandle == null) {
                return chain.execute(exchange);
            }
            return chain.execute(this.converter(exchange, jwtBody, ruleHandle.getConverter()));
        }
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ERROR_TOKEN, null);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    public String named() {
        return PluginEnum.JWT.getName();
    }

    public int getOrder() {
        return PluginEnum.JWT.getCode();
    }

    private String compatible(String token, String authorization) {
        String finalAuthorization;
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            finalAuthorization = token;
        } else if (StringUtils.isNotEmpty((CharSequence)authorization)) {
            finalAuthorization = authorization;
        } else {
            return null;
        }
        return this.isAuth2(finalAuthorization) ? finalAuthorization.split(" ")[1] : finalAuthorization;
    }

    private boolean isAuth2(String authorization) {
        return authorization.contains(AUTH2_TOKEN);
    }

    private Map<String, String> checkAuthorization(String authorization, String secretKey) {
        if (StringUtils.isEmpty((CharSequence)authorization)) {
            return null;
        }
        JwtParser jwtParser = Jwts.parser();
        if (jwtParser.isSigned(authorization)) {
            jwtParser.setSigningKey(secretKey.getBytes(StandardCharsets.UTF_8));
            Jwt jwt = ThrowingFunction.wrap(() -> jwtParser.parse(authorization));
            return jwt == null ? null : GsonUtils.getInstance().toObjectMap(String.valueOf(jwt.getBody()), String.class);
        }
        return null;
    }

    private ServerWebExchange converter(ServerWebExchange exchange, Map<String, String> jwtBody, List<JwtRuleHandle.Convert> converters) {
        ServerHttpRequest modifiedRequest = exchange.getRequest().mutate().headers(httpHeaders -> this.addHeader((HttpHeaders)httpHeaders, jwtBody, converters)).build();
        return exchange.mutate().request(modifiedRequest).build();
    }

    private void addHeader(HttpHeaders headers, Map<String, String> body, List<JwtRuleHandle.Convert> converters) {
        for (JwtRuleHandle.Convert converter : converters) {
            headers.add(converter.getHeaderVal(), body.get(converter.getJwtVal()));
        }
    }
}

