/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class NettyHttpClientPlugin
implements ShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpClientPlugin.class);
    private final HttpClient httpClient;

    public NettyHttpClientPlugin(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        URI uri;
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethodValue());
        HttpHeaders filtered = request.getHeaders();
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        filtered.forEach((arg_0, arg_1) -> ((DefaultHttpHeaders)httpHeaders).set(arg_0, arg_1));
        String acceptEncoding = httpHeaders.get("Accept-Encoding");
        if (StringUtils.isNotBlank((CharSequence)acceptEncoding)) {
            List acceptEncodings = Stream.of(acceptEncoding.trim().split(",")).collect(Collectors.toList());
            acceptEncodings.remove("gzip");
            httpHeaders.set("Accept-Encoding", (Object)String.join((CharSequence)",", acceptEncodings));
        }
        if (Objects.isNull(uri = (URI)exchange.getAttribute("httpUri"))) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_FIND_URL, null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        LOG.info("you request, The resulting urlPath is: {}", (Object)uri.toASCIIString());
        Flux responseFlux = ((HttpClient.RequestSender)this.httpClient.headers(headers -> headers.add((io.netty.handler.codec.http.HttpHeaders)httpHeaders)).request(method).uri(uri.toASCIIString())).send((req, nettyOutbound) -> nettyOutbound.send((Publisher)request.getBody().map(dataBuffer -> ((NettyDataBuffer)dataBuffer).getNativeBuffer()))).responseConnection((res, connection) -> {
            HttpStatus status;
            exchange.getAttributes().put("webHandlerClientResponse", res);
            exchange.getAttributes().put("nettyClientResponseConnection", connection);
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = new HttpHeaders();
            res.responseHeaders().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
            String contentTypeValue = headers.getFirst("Content-Type");
            if (StringUtils.isNotBlank((CharSequence)contentTypeValue)) {
                exchange.getAttributes().put("original_response_content_type", contentTypeValue);
            }
            if ((status = HttpStatus.resolve((int)res.status().code())) != null) {
                response.setStatusCode(status);
            } else if (response instanceof AbstractServerHttpResponse) {
                ((AbstractServerHttpResponse)response).setStatusCodeValue(Integer.valueOf(res.status().code()));
            } else {
                throw new IllegalStateException("Unable to set status code on response: " + res.status().code() + ", " + response.getClass());
            }
            response.getHeaders().putAll((Map)headers);
            return Mono.just((Object)res);
        });
        long timeout = (Long)Optional.ofNullable(exchange.getAttribute("httpTimeOut")).orElse(3000L);
        Duration duration = Duration.ofMillis(timeout);
        responseFlux = responseFlux.timeout(duration, (Publisher)Mono.error((Throwable)new TimeoutException("Response took longer than timeout: " + duration))).onErrorMap(TimeoutException.class, th -> new ResponseStatusException(HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th));
        return responseFlux.then(chain.execute(exchange));
    }

    public int getOrder() {
        return PluginEnum.NETTY_HTTP_CLIENT.getCode();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }

    public String named() {
        return PluginEnum.NETTY_HTTP_CLIENT.getName();
    }
}

