/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.result;

import java.util.Objects;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ObjectTypeUtils;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;

public interface ShenyuResult<T> {
    default public Object result(ServerWebExchange exchange, Object formatted) {
        return formatted;
    }

    default public Object format(ServerWebExchange exchange, Object origin) {
        if (ObjectTypeUtils.isBasicType((Object)origin) || origin instanceof byte[]) {
            return origin;
        }
        return JsonUtils.toJson((Object)origin);
    }

    default public MediaType contentType(ServerWebExchange exchange, Object formatted) {
        ClientResponse clientResponse = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
        if (Objects.nonNull(clientResponse) && clientResponse.headers().contentType().isPresent()) {
            return (MediaType)clientResponse.headers().contentType().get();
        }
        return MediaType.APPLICATION_JSON;
    }

    default public T error(ServerWebExchange exchange, int code, String message, Object object) {
        return this.error(code, message, object);
    }

    default public T error(int code, String message, Object object) {
        return null;
    }
}

