/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.proto;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.grpc.stub.StreamObserver;
import org.apache.shenyu.plugin.grpc.proto.ShenyuGrpcResponse;
import org.apache.shenyu.protocol.grpc.message.JsonMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageWriter<T extends Message>
implements StreamObserver<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageWriter.class);
    private final ShenyuGrpcResponse grpcResponse;

    private MessageWriter(ShenyuGrpcResponse grpcResponse) {
        this.grpcResponse = grpcResponse;
    }

    public static <T extends Message> MessageWriter<T> newInstance(ShenyuGrpcResponse results) {
        return new MessageWriter<T>(results);
    }

    public void onNext(T value) {
        String respData = JsonMessage.getDataFromDynamicMessage((DynamicMessage)((DynamicMessage)value));
        this.grpcResponse.getResults().add(respData);
    }

    public void onError(Throwable t) {
        LOG.error("Messages write occur errors", t);
    }

    public void onCompleted() {
        LOG.info("Messages write complete");
    }
}

