/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.sentinel;

import com.alibaba.csp.sentinel.adapter.spring.webflux.exception.SentinelBlockExceptionHandler;
import java.util.Collections;
import java.util.List;
import org.apache.shenyu.plugin.base.fallback.FallbackHandler;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.sentinel.SentinelPlugin;
import org.apache.shenyu.plugin.sentinel.fallback.SentinelFallbackHandler;
import org.apache.shenyu.plugin.sentinel.handler.SentinelRuleHandle;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;

@Configuration
public class SentinelPluginConfiguration {
    private final List<ViewResolver> viewResolvers;
    private final ServerCodecConfigurer serverCodecConfigurer;

    public SentinelPluginConfiguration(ObjectProvider<List<ViewResolver>> listObjectProvider, ServerCodecConfigurer serverCodecConfigurer) {
        this.viewResolvers = (List)listObjectProvider.getIfAvailable(Collections::emptyList);
        this.serverCodecConfigurer = serverCodecConfigurer;
    }

    @Bean
    public SentinelPlugin sentinelPlugin(FallbackHandler fallbackHandler) {
        return new SentinelPlugin(fallbackHandler);
    }

    @Bean
    @ConditionalOnMissingBean(value={FallbackHandler.class})
    public FallbackHandler fallbackHandler() {
        return new SentinelFallbackHandler();
    }

    @Bean
    public PluginDataHandler sentinelRuleHandle() {
        return new SentinelRuleHandle();
    }

    @Bean
    @Order(value=-2147483648)
    public SentinelBlockExceptionHandler sentinelBlockExceptionHandler() {
        return new SentinelBlockExceptionHandler(this.viewResolvers, this.serverCodecConfigurer);
    }
}

