/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.netty;

import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import java.util.Optional;
import org.apache.shenyu.springboot.starter.netty.NettyTcpProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.netty.http.server.HttpServer;
import reactor.netty.resources.LoopResources;

@Configuration
public class ShenyuNettyWebServerConfiguration {
    @Bean
    @ConfigurationProperties(prefix="shenyu.netty.tcp")
    public NettyTcpProperties nettyTcpProperties() {
        return new NettyTcpProperties();
    }

    @Bean
    @ConditionalOnProperty(value={"shenyu.netty.tcp.webServerFactoryEnabled"}, havingValue="true", matchIfMissing=true)
    public NettyReactiveWebServerFactory nettyReactiveWebServerFactory(ObjectProvider<NettyTcpProperties> properties) {
        NettyReactiveWebServerFactory webServerFactory = new NettyReactiveWebServerFactory();
        NettyTcpProperties nettyTcpProperties = (NettyTcpProperties)Optional.ofNullable(properties.getIfAvailable()).orElse(new NettyTcpProperties());
        webServerFactory.addServerCustomizers(new NettyServerCustomizer[]{new EventLoopNettyCustomizer(nettyTcpProperties)});
        return webServerFactory;
    }

    private static class EventLoopNettyCustomizer
    implements NettyServerCustomizer {
        private final NettyTcpProperties nettyTcpProperties;

        EventLoopNettyCustomizer(NettyTcpProperties nettyTcpProperties) {
            this.nettyTcpProperties = nettyTcpProperties;
        }

        public HttpServer apply(HttpServer httpServer) {
            return httpServer.tcpConfiguration(tcpServer -> tcpServer.runOn(LoopResources.create((String)"shenyu-netty", (int)this.nettyTcpProperties.getSelectCount(), (int)this.nettyTcpProperties.getWorkerCount(), (boolean)true)).selectorOption(ChannelOption.SO_BACKLOG, (Object)this.nettyTcpProperties.getServerSocketChannel().getSoBacklog()).selectorOption(ChannelOption.SO_REUSEADDR, (Object)this.nettyTcpProperties.getServerSocketChannel().isSoReuseAddr()).selectorOption(ChannelOption.SO_RCVBUF, (Object)this.nettyTcpProperties.getServerSocketChannel().getSoRcvBuf()).selectorOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyTcpProperties.getServerSocketChannel().getConnectTimeoutMillis()).selectorOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyTcpProperties.getServerSocketChannel().getWriteBufferLowWaterMark().intValue(), this.nettyTcpProperties.getServerSocketChannel().getWriteBufferHighWaterMark().intValue())).selectorOption(ChannelOption.WRITE_SPIN_COUNT, (Object)this.nettyTcpProperties.getServerSocketChannel().getWriteSpinCount()).selectorOption(ChannelOption.AUTO_READ, (Object)this.nettyTcpProperties.getServerSocketChannel().isAutoRead()).selectorOption(ChannelOption.ALLOCATOR, (Object)this.nettyTcpProperties.getServerSocketChannel().getAllocator()).option(ChannelOption.SO_KEEPALIVE, (Object)this.nettyTcpProperties.getSocketChannel().isSoKeepAlive()).option(ChannelOption.SO_REUSEADDR, (Object)this.nettyTcpProperties.getSocketChannel().isSoReuseAddr()).option(ChannelOption.SO_LINGER, (Object)this.nettyTcpProperties.getSocketChannel().getSoLinger()).option(ChannelOption.TCP_NODELAY, (Object)this.nettyTcpProperties.getSocketChannel().isTcpNoDelay()).option(ChannelOption.SO_RCVBUF, (Object)this.nettyTcpProperties.getSocketChannel().getSoRcvBuf()).option(ChannelOption.SO_SNDBUF, (Object)this.nettyTcpProperties.getSocketChannel().getSoSndBuf()).option(ChannelOption.IP_TOS, (Object)this.nettyTcpProperties.getSocketChannel().getIpTos()).option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)this.nettyTcpProperties.getSocketChannel().isAllowHalfClosure()).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyTcpProperties.getSocketChannel().getConnectTimeoutMillis()).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyTcpProperties.getSocketChannel().getWriteBufferLowWaterMark().intValue(), this.nettyTcpProperties.getSocketChannel().getWriteBufferHighWaterMark().intValue())).option(ChannelOption.WRITE_SPIN_COUNT, (Object)this.nettyTcpProperties.getSocketChannel().getWriteSpinCount()).option(ChannelOption.AUTO_READ, (Object)this.nettyTcpProperties.getSocketChannel().isAutoRead()).option(ChannelOption.ALLOCATOR, (Object)this.nettyTcpProperties.getSocketChannel().getAllocator()));
        }
    }
}

