/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.dependencies.zipkin2.reporter.okhttp3;

import java.io.IOException;
import org.apache.shenyu.dependencies.okhttp3.Response;
import org.apache.shenyu.dependencies.okhttp3.ResponseBody;
import org.apache.shenyu.dependencies.okio.BufferedSource;
import org.apache.shenyu.dependencies.okio.GzipSource;
import org.apache.shenyu.dependencies.okio.Okio;
import org.apache.shenyu.dependencies.zipkin2.Call;
import org.apache.shenyu.dependencies.zipkin2.Callback;

final class HttpCall
extends Call<Void> {
    final org.apache.shenyu.dependencies.okhttp3.Call call;

    HttpCall(org.apache.shenyu.dependencies.okhttp3.Call call) {
        this.call = call;
    }

    @Override
    public Void execute() throws IOException {
        HttpCall.parseResponse(this.call.execute());
        return null;
    }

    @Override
    public void enqueue(Callback<Void> delegate) {
        this.call.enqueue(new V2CallbackAdapter<Void>(delegate));
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    public HttpCall clone() {
        return new HttpCall(this.call.clone());
    }

    static void parseResponse(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            if (response.isSuccessful()) {
                return;
            }
            throw new RuntimeException("response failed: " + response);
        }
        try {
            BufferedSource content = responseBody.source();
            if ("gzip".equalsIgnoreCase(response.header("Content-Encoding"))) {
                content = Okio.buffer(new GzipSource(responseBody.source()));
            }
            if (!response.isSuccessful()) {
                throw new RuntimeException("response for " + response.request().tag() + " failed: " + content.readUtf8());
            }
        }
        finally {
            responseBody.close();
        }
    }

    static class V2CallbackAdapter<V>
    implements org.apache.shenyu.dependencies.okhttp3.Callback {
        final Callback<V> delegate;

        V2CallbackAdapter(Callback<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onFailure(org.apache.shenyu.dependencies.okhttp3.Call call, IOException e) {
            this.delegate.onError(e);
        }

        @Override
        public void onResponse(org.apache.shenyu.dependencies.okhttp3.Call call, Response response) {
            try {
                HttpCall.parseResponse(response);
                this.delegate.onSuccess(null);
            }
            catch (Throwable e) {
                Call.propagateIfFatal(e);
                this.delegate.onError(e);
            }
        }
    }
}

