/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.zipkin.span;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shenyu.dependencies.brave.Span;
import org.apache.shenyu.dependencies.brave.Tracing;
import org.springframework.web.server.ServerWebExchange;

public class ZipkinSpanManager {
    private volatile Span lastSpan;
    private final AtomicInteger count = new AtomicInteger(0);

    public Span start(String spanName, Map<String, String> tagMap) {
        Span span = Objects.isNull(this.lastSpan) ? Tracing.currentTracer().nextSpan().name(spanName) : Tracing.currentTracer().newChild(this.lastSpan.context()).name(spanName);
        tagMap.forEach(span::tag);
        span.start();
        this.count.incrementAndGet();
        this.lastSpan = span;
        return span;
    }

    public void finish(Span span, ServerWebExchange exchange) {
        span.finish();
        if (this.count.decrementAndGet() == 0) {
            exchange.getAttributes().remove("shenyu-agent");
        }
    }
}

