/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.zipkin.handler;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.shenyu.agent.api.entity.MethodResult;
import org.apache.shenyu.agent.api.entity.TargetObject;
import org.apache.shenyu.agent.api.handler.InstanceMethodHandler;
import org.apache.shenyu.agent.plugin.tracing.zipkin.span.ZipkinSpanManager;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.dependencies.brave.Span;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ZipkinPluginCommonHandler
implements InstanceMethodHandler {
    @Override
    public void before(TargetObject target, Method method, Object[] args, MethodResult result) {
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        ZipkinSpanManager zipkinSpanManager = exchange.getAttributes().getOrDefault("shenyu-agent", new ZipkinSpanManager());
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put("component", "shenyu");
        for (int i = 2; i < args.length; ++i) {
            tagMap.put(args[i].getClass().getName(), GsonUtils.getGson().toJson(args[i]));
        }
        Span span = zipkinSpanManager.start(method.getDeclaringClass().getSimpleName(), tagMap);
        exchange.getAttributes().put("shenyu-agent", zipkinSpanManager);
        target.setContext(span);
    }

    @Override
    public Object after(TargetObject target, Method method, Object[] args, MethodResult methodResult, Object result) {
        Span span = (Span)target.getContext();
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        ZipkinSpanManager manager = (ZipkinSpanManager)exchange.getAttributes().get("shenyu-agent");
        if (result instanceof Mono) {
            return ((Mono)result).doFinally(s -> manager.finish(span, exchange));
        }
        manager.finish(span, exchange);
        return result;
    }

    @Override
    public void onThrowing(TargetObject target, Method method, Object[] args, Throwable throwable) {
        Span span = (Span)target.getContext();
        span.error(throwable);
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        ZipkinSpanManager manager = (ZipkinSpanManager)exchange.getAttributes().get("shenyu-agent");
        manager.finish(span, exchange);
    }
}

