/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.zipkin.boot;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.agent.api.config.AgentPluginConfig;
import org.apache.shenyu.agent.api.exception.ShenyuAgentException;
import org.apache.shenyu.agent.api.spi.AgentPluginBootService;
import org.apache.shenyu.dependencies.brave.Tracing;
import org.apache.shenyu.dependencies.brave.sampler.BoundarySampler;
import org.apache.shenyu.dependencies.brave.sampler.RateLimitingSampler;
import org.apache.shenyu.dependencies.brave.sampler.Sampler;
import org.apache.shenyu.dependencies.zipkin2.reporter.brave.AsyncZipkinSpanHandler;
import org.apache.shenyu.dependencies.zipkin2.reporter.okhttp3.OkHttpSender;
import org.apache.shenyu.spi.Join;

@Join
public class ZipkinAgentPluginBootService
implements AgentPluginBootService {
    private static final String DEFAULT_URL_VERSION = "/api/v2/spans";
    private static final String DEFAULT_SERVICE_NAME = "shenyu-agent";
    private static final String DEFAULT_SAMPLER_TYPE = "const";
    private static final String DEFAULT_SAMPLER_PARAM = "1";
    private AsyncZipkinSpanHandler zipkinSpanHandler;
    private OkHttpSender sender;
    private Tracing tracing;

    @Override
    public void start(AgentPluginConfig agentPluginConfig) {
        if (StringUtils.isEmpty((CharSequence)agentPluginConfig.getHost()) || agentPluginConfig.getPort() < 0) {
            throw new ShenyuAgentException("zipkin config error, host can not config or port is %s", agentPluginConfig.getPort());
        }
        Properties props = agentPluginConfig.getProps();
        String urlVersion = Optional.ofNullable(props.getProperty("URL_VERSION")).orElse(DEFAULT_URL_VERSION);
        this.sender = OkHttpSender.create(String.format("http://%s:%s%s", agentPluginConfig.getHost(), agentPluginConfig.getPort(), urlVersion));
        this.zipkinSpanHandler = AsyncZipkinSpanHandler.create(this.sender);
        Sampler sampler = this.createSampler(agentPluginConfig);
        String serviceName = Optional.ofNullable(props.getProperty("SERVICE_NAME")).orElse(DEFAULT_SERVICE_NAME);
        this.tracing = Tracing.newBuilder().localServiceName(serviceName).sampler(sampler).addSpanHandler(this.zipkinSpanHandler).build();
    }

    @Override
    public void close() {
        if (Objects.nonNull(this.tracing)) {
            this.tracing.close();
        }
        if (Objects.nonNull(this.zipkinSpanHandler)) {
            this.zipkinSpanHandler.close();
        }
        if (Objects.nonNull(this.sender)) {
            this.sender.close();
        }
    }

    private Sampler createSampler(AgentPluginConfig agentPluginConfig) {
        String samplerType = Optional.ofNullable(agentPluginConfig.getProps().getProperty("SAMPLER_TYPE")).orElse(DEFAULT_SAMPLER_TYPE);
        String samplerParam = Optional.ofNullable(agentPluginConfig.getProps().getProperty("SAMPLER_PARAM")).orElse(DEFAULT_SAMPLER_PARAM);
        switch (samplerType) {
            case "const": {
                if (Objects.equals(samplerParam, "0")) {
                    return Sampler.NEVER_SAMPLE;
                }
                return Sampler.ALWAYS_SAMPLE;
            }
            case "counting": {
                return Sampler.create(Float.parseFloat(samplerParam));
            }
            case "ratelimiting": {
                return RateLimitingSampler.create(Integer.parseInt(samplerParam));
            }
            case "boundary": {
                return BoundarySampler.create(Float.parseFloat(samplerParam));
            }
        }
        return Sampler.ALWAYS_SAMPLE;
    }
}

