/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.common.constant;

/**
 * The type Admin constants.
 */
public final class AdminConstants {

    /**
     * The constant SUCCESS, equals to ShenyuResultMessage.SUCCESS.
     */
    public static final String SUCCESS = "SUCCESS";

    /**
     * The constant PLUGIN_NAME_IS_EXIST.
     */
    public static final String PLUGIN_NAME_IS_EXIST = "The plugin name already exists and can't be added repeatedly!";

    /**
     * The constant ID_NOT_EXIST.
     */
    public static final String ID_NOT_EXIST = "ID NOT EXIST!";

    /**
     * The constant PLUGIN_NAME_NOT_EXIST.
     */
    public static final String PLUGIN_NAME_NOT_EXIST = "The plugin name not exist!";

    /**
     * The constant SYS_PLUGIN_NOT_DELETE.
     */
    public static final String SYS_PLUGIN_NOT_DELETE = "System plugins can't be deleted!";

    /**
     * The constant SYS_PLUGIN_ID_NOT_EXIST.
     */
    public static final String SYS_PLUGIN_ID_NOT_EXIST = "The plugin id does not exist！";

    /**
     * The constant DATA_PATH_IS_EXIST.
     */
    public static final String DATA_PATH_IS_EXIST = "The path already exists and can't be added repeatedly!";

    /**
     * The constant PARAMS_ERROR.
     */
    public static final String PARAMS_ERROR = "Error parameter！";

    /**
     * The constant Super Role ID.
     */
    public static final String ROLE_SUPER_ID = "1346358560427216896";

    /**
     * The constant Plugin Menu ID.
     */
    public static final String RESOURCE_PLUGIN_ID = "1346775491550474240";

    /**
     * The constant Plugin Url prefix.
     */
    public static final String RESOURCE_PLUGIN_URL_PREFIX = "/plug/";

    /**
     * The constant Plugin Resource Icon.
     */
    public static final String RESOURCE_PLUGIN_DEFAULT_ICON = "block";

    /**
     * The constant Selector Name.
     */
    public static final String DATA_PERMISSION_SELECTOR = "selector";

    /**
     * The constant Rule Name.
     */
    public static final String DATA_PERMISSION_RULE = "rule";

    /**
     * The constant Admin Name.
     */
    public static final String ADMIN_NAME = "admin";

    /**
     * The constant selector data type.
     */
    public static final Integer SELECTOR_DATA_TYPE = 0;

    /**
     * the constant rule data type.
     */
    public static final Integer RULE_DATA_TYPE = 1;

}
