/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.response.strategy;

import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientMessageWriter
implements MessageWriter {
    @Override
    public Mono<Void> writeWith(ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            ServerHttpResponse response = exchange.getResponse();
            ClientResponse clientResponse = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
            if (Objects.isNull(clientResponse) || response.getStatusCode() == HttpStatus.BAD_GATEWAY || response.getStatusCode() == HttpStatus.INTERNAL_SERVER_ERROR) {
                Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            if (response.getStatusCode() == HttpStatus.GATEWAY_TIMEOUT) {
                Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_TIMEOUT.getCode(), (String)ShenyuResultEnum.SERVICE_TIMEOUT.getMsg(), null);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            response.getCookies().putAll((Map)clientResponse.cookies());
            response.getHeaders().putAll((Map)clientResponse.headers().asHttpHeaders());
            return response.writeWith((Publisher)clientResponse.body(BodyExtractors.toDataBuffers())).doOnCancel(() -> this.clean(exchange));
        }));
    }

    private void clean(ServerWebExchange exchange) {
        ClientResponse clientResponse = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
        if (clientResponse != null) {
            clientResponse.bodyToMono(Void.class).subscribe();
        }
    }
}

