/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.response.strategy;

import java.util.Objects;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RPCMessageWriter
implements MessageWriter {
    @Override
    public Mono<Void> writeWith(ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            Object result = exchange.getAttribute("rpc_result");
            if (Objects.isNull(result)) {
                Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)ShenyuResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            Object success = ShenyuResultWrap.success((int)ShenyuResultEnum.SUCCESS.getCode(), (String)ShenyuResultEnum.SUCCESS.getMsg(), (Object)JsonUtils.removeClass((Object)result));
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)success);
        }));
    }
}

