/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa.subscriber;

import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.sofa.cache.ApplicationConfigCache;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;

public class SofaMetaDataSubscriber
implements MetaDataSubscriber {
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();

    public void onSubscribe(MetaData metaData) {
        if (RpcTypeEnum.SOFA.getName().equals(metaData.getRpcType())) {
            MetaData exist = (MetaData)META_DATA.get(metaData.getPath());
            if (Objects.isNull(exist) || Objects.isNull(ApplicationConfigCache.getInstance().get(exist.getPath()).refer())) {
                ApplicationConfigCache.getInstance().initRef(metaData);
            } else if (!exist.getServiceName().equals(metaData.getServiceName()) || !exist.getRpcExt().equals(metaData.getRpcExt())) {
                ApplicationConfigCache.getInstance().build(metaData);
            }
            META_DATA.put(metaData.getPath(), metaData);
        }
    }

    public void unSubscribe(MetaData metaData) {
        if (RpcTypeEnum.SOFA.getName().equals(metaData.getRpcType())) {
            ApplicationConfigCache.getInstance().invalidate(metaData.getPath());
            META_DATA.remove(metaData.getPath());
        }
    }
}

