/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.RemotingServer;
import com.alipay.remoting.config.AbstractConfigurableInstance;
import com.alipay.remoting.config.configs.ConfigType;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class AbstractRemotingServer
extends AbstractConfigurableInstance
implements RemotingServer {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private AtomicBoolean started = new AtomicBoolean(false);
    private String ip;
    private int port;

    public AbstractRemotingServer(int port) {
        this(new InetSocketAddress(port).getAddress().getHostAddress(), port);
    }

    public AbstractRemotingServer(String ip, int port) {
        super(ConfigType.SERVER_SIDE);
        this.ip = ip;
        this.port = port;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean start() {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.doInit();
                logger.warn("Prepare to start server on port {} ", (Object)this.port);
                if (this.doStart()) {
                    logger.warn("Server started on port {}", (Object)this.port);
                    return true;
                }
                logger.warn("Failed starting server on port {}", (Object)this.port);
                return false;
            }
            catch (Throwable t) {
                this.stop();
                throw new IllegalStateException("ERROR: Failed to start the Server!", t);
            }
        }
        String errMsg = "ERROR: The server has already started!";
        logger.error(errMsg);
        throw new IllegalStateException(errMsg);
    }

    @Override
    public boolean stop() {
        if (this.started.compareAndSet(true, false)) {
            return this.doStop();
        }
        throw new IllegalStateException("ERROR: The server has already stopped!");
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public int port() {
        return this.port;
    }

    protected abstract void doInit();

    protected abstract boolean doStart() throws InterruptedException;

    protected abstract boolean doStop();
}

