/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.zookeeper;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.constant.DefaultPathConstants;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;

public class ZookeeperSyncDataService
implements SyncDataService,
AutoCloseable {
    private final ZkClient zkClient;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public ZookeeperSyncDataService(ZkClient zkClient, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.zkClient = zkClient;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
        this.watcherData();
        this.watchAppAuth();
        this.watchMetaData();
    }

    private void watcherData() {
        String pluginParent = "/shenyu/plugin";
        List<String> pluginZKs = this.zkClientGetChildren("/shenyu/plugin");
        for (String pluginName : pluginZKs) {
            this.watcherAll(pluginName);
        }
        this.zkClient.subscribeChildChanges("/shenyu/plugin", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                for (String pluginName : currentChildren) {
                    this.watcherAll(pluginName);
                }
            }
        });
    }

    private void watcherAll(String pluginName) {
        this.watcherPlugin(pluginName);
        this.watcherSelector(pluginName);
        this.watcherRule(pluginName);
    }

    private void watcherPlugin(String pluginName) {
        String pluginPath = DefaultPathConstants.buildPluginPath((String)pluginName);
        if (!this.zkClient.exists(pluginPath)) {
            this.zkClient.createPersistent(pluginPath, true);
        }
        PluginData pluginData = null == this.zkClient.readData(pluginPath) ? null : (PluginData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(pluginPath), PluginData.class);
        this.cachePluginData(pluginData);
        this.subscribePluginDataChanges(pluginPath, pluginName);
    }

    private void watcherSelector(String pluginName) {
        String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)pluginName);
        List<String> childrenList = this.zkClientGetChildren(selectorParentPath);
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(selectorParentPath, (String)children);
                SelectorData selectorData = null == this.zkClient.readData(realPath) ? null : (SelectorData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), SelectorData.class);
                this.cacheSelectorData(selectorData);
                this.subscribeSelectorDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.SELECTOR, selectorParentPath, childrenList);
    }

    private void watcherRule(String pluginName) {
        String ruleParent = DefaultPathConstants.buildRuleParentPath((String)pluginName);
        List<String> childrenList = this.zkClientGetChildren(ruleParent);
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(ruleParent, (String)children);
                RuleData ruleData = null == this.zkClient.readData(realPath) ? null : (RuleData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), RuleData.class);
                this.cacheRuleData(ruleData);
                this.subscribeRuleDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.RULE, ruleParent, childrenList);
    }

    private void watchAppAuth() {
        String appAuthParent = "/shenyu/auth";
        List<String> childrenList = this.zkClientGetChildren("/shenyu/auth");
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/shenyu/auth", (String)children);
                AppAuthData appAuthData = null == this.zkClient.readData(realPath) ? null : (AppAuthData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), AppAuthData.class);
                this.cacheAuthData(appAuthData);
                this.subscribeAppAuthDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.APP_AUTH, "/shenyu/auth", childrenList);
    }

    private void watchMetaData() {
        String metaDataPath = "/shenyu/metaData";
        List<String> childrenList = this.zkClientGetChildren("/shenyu/metaData");
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/shenyu/metaData", (String)children);
                MetaData metaData = null == this.zkClient.readData(realPath) ? null : (MetaData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), MetaData.class);
                this.cacheMetaData(metaData);
                this.subscribeMetaDataChanges(realPath);
            });
        }
        this.subscribeChildChanges(ConfigGroupEnum.META_DATA, "/shenyu/metaData", childrenList);
    }

    private void subscribeChildChanges(ConfigGroupEnum groupKey, String groupParentPath, List<String> childrenList) {
        switch (groupKey) {
            case SELECTOR: {
                this.zkClient.subscribeChildChanges(groupParentPath, (parentPath, currentChildren) -> {
                    if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                        List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                        addSubscribePath.stream().map(addPath -> {
                            String realPath = this.buildRealPath(parentPath, (String)addPath);
                            SelectorData selectorData = null == this.zkClient.readData(realPath) ? null : (SelectorData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), SelectorData.class);
                            this.cacheSelectorData(selectorData);
                            return realPath;
                        }).forEach(this::subscribeSelectorDataChanges);
                    }
                });
                break;
            }
            case RULE: {
                this.zkClient.subscribeChildChanges(groupParentPath, (parentPath, currentChildren) -> {
                    if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                        List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                        addSubscribePath.stream().map(addPath -> {
                            String realPath = this.buildRealPath(parentPath, (String)addPath);
                            RuleData ruleData = null == this.zkClient.readData(realPath) ? null : (RuleData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), RuleData.class);
                            this.cacheRuleData(ruleData);
                            return realPath;
                        }).forEach(this::subscribeRuleDataChanges);
                    }
                });
                break;
            }
            case APP_AUTH: {
                this.zkClient.subscribeChildChanges(groupParentPath, (parentPath, currentChildren) -> {
                    if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                        List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                        addSubscribePath.stream().map(children -> {
                            String realPath = this.buildRealPath(parentPath, (String)children);
                            AppAuthData appAuthData = null == this.zkClient.readData(realPath) ? null : (AppAuthData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), AppAuthData.class);
                            this.cacheAuthData(appAuthData);
                            return realPath;
                        }).forEach(this::subscribeAppAuthDataChanges);
                    }
                });
                break;
            }
            case META_DATA: {
                this.zkClient.subscribeChildChanges(groupParentPath, (parentPath, currentChildren) -> {
                    if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                        List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                        addSubscribePath.stream().map(children -> {
                            String realPath = this.buildRealPath(parentPath, (String)children);
                            MetaData metaData = null == this.zkClient.readData(realPath) ? null : (MetaData)GsonUtils.getInstance().fromJson((String)this.zkClient.readData(realPath), MetaData.class);
                            this.cacheMetaData(metaData);
                            return realPath;
                        }).forEach(this::subscribeMetaDataChanges);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected groupKey: " + groupKey);
            }
        }
    }

    private void subscribePluginDataChanges(String pluginPath, final String pluginName) {
        this.zkClient.subscribeDataChanges(pluginPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(d -> Optional.ofNullable(ZookeeperSyncDataService.this.pluginDataSubscriber).ifPresent(e -> e.onSubscribe((PluginData)GsonUtils.getInstance().fromJson(data.toString(), PluginData.class))));
            }

            public void handleDataDeleted(String dataPath) {
                PluginData data = new PluginData();
                data.setName(pluginName);
                Optional.ofNullable(ZookeeperSyncDataService.this.pluginDataSubscriber).ifPresent(e -> e.unSubscribe(data));
            }
        });
    }

    private void subscribeSelectorDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheSelectorData((SelectorData)GsonUtils.getInstance().fromJson(data.toString(), SelectorData.class));
            }

            public void handleDataDeleted(String dataPath) {
                ZookeeperSyncDataService.this.unCacheSelectorData(dataPath);
            }
        });
    }

    private void subscribeRuleDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheRuleData((RuleData)GsonUtils.getInstance().fromJson(data.toString(), RuleData.class));
            }

            public void handleDataDeleted(String dataPath) {
                ZookeeperSyncDataService.this.unCacheRuleData(dataPath);
            }
        });
    }

    private void subscribeAppAuthDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheAuthData((AppAuthData)GsonUtils.getInstance().fromJson(data.toString(), AppAuthData.class));
            }

            public void handleDataDeleted(String dataPath) {
                ZookeeperSyncDataService.this.unCacheAuthData(dataPath);
            }
        });
    }

    private void subscribeMetaDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheMetaData((MetaData)GsonUtils.getInstance().fromJson(data.toString(), MetaData.class));
            }

            public void handleDataDeleted(String dataPath) throws UnsupportedEncodingException {
                String realPath = dataPath.substring("/shenyu/metaData".length() + 1);
                MetaData metaData = new MetaData();
                metaData.setPath(URLDecoder.decode(realPath, StandardCharsets.UTF_8.name()));
                ZookeeperSyncDataService.this.unCacheMetaData(metaData);
            }
        });
    }

    private void cachePluginData(PluginData pluginData) {
        Optional.ofNullable(pluginData).flatMap(data -> Optional.ofNullable(this.pluginDataSubscriber)).ifPresent(e -> e.onSubscribe(pluginData));
    }

    private void cacheSelectorData(SelectorData selectorData) {
        Optional.ofNullable(selectorData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSelectorSubscribe(data)));
    }

    private void unCacheSelectorData(String dataPath) {
        SelectorData selectorData = new SelectorData();
        String selectorId = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/selector".length());
        String pluginName = str.substring(1, str.length() - selectorId.length() - 1);
        selectorData.setPluginName(pluginName);
        selectorData.setId(selectorId);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSelectorSubscribe(selectorData));
    }

    private void cacheRuleData(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onRuleSubscribe(data)));
    }

    private void unCacheRuleData(String dataPath) {
        String substring = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/rule".length());
        String pluginName = str.substring(1, str.length() - substring.length() - 1);
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"-").split((CharSequence)substring));
        RuleData ruleData = new RuleData();
        ruleData.setPluginName(pluginName);
        ruleData.setSelectorId((String)list.get(0));
        ruleData.setId((String)list.get(1));
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unRuleSubscribe(ruleData));
    }

    private void cacheAuthData(AppAuthData appAuthData) {
        Optional.ofNullable(appAuthData).ifPresent(data -> this.authDataSubscribers.forEach(e -> e.onSubscribe(data)));
    }

    private void unCacheAuthData(String dataPath) {
        String key = dataPath.substring("/shenyu/auth".length() + 1);
        AppAuthData appAuthData = new AppAuthData();
        appAuthData.setAppKey(key);
        this.authDataSubscribers.forEach(e -> e.unSubscribe(appAuthData));
    }

    private void cacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.onSubscribe(metaData)));
    }

    private void unCacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.unSubscribe(metaData)));
    }

    private List<String> addSubscribePath(List<String> alreadyChildren, List<String> currentChildren) {
        if (CollectionUtils.isEmpty(alreadyChildren)) {
            return currentChildren;
        }
        return currentChildren.stream().filter(current -> alreadyChildren.stream().noneMatch(current::equals)).collect(Collectors.toList());
    }

    private String buildRealPath(String parent, String children) {
        return parent + "/" + children;
    }

    private List<String> zkClientGetChildren(String parent) {
        if (!this.zkClient.exists(parent)) {
            this.zkClient.createPersistent(parent, true);
        }
        return this.zkClient.getChildren(parent);
    }

    @Override
    public void close() {
        if (null != this.zkClient) {
            this.zkClient.close();
        }
    }
}

