/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import java.io.File;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class ShenyuPluginPathBuilder {
    private static final String PLUGIN_PATH = "plugin-ext";
    private static final String DEFAULT_EXT_PLUGIN_PATH = "/ext-lib/";

    public static File getPluginPath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return new File(path);
        }
        String pluginPath = System.getProperty(PLUGIN_PATH);
        if (StringUtils.isNotEmpty((CharSequence)pluginPath)) {
            return new File(pluginPath);
        }
        return ShenyuPluginPathBuilder.buildPluginJarPath();
    }

    private static File buildPluginJarPath() {
        URL url = ShenyuPluginPathBuilder.class.getResource(DEFAULT_EXT_PLUGIN_PATH);
        return Optional.ofNullable(url).map(u -> new File(u.getFile())).orElse(new File(DEFAULT_EXT_PLUGIN_PATH));
    }
}

